/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListOrganizationAdminAccountsResponse extends GuardDutyResponse implements
        ToCopyableBuilder<ListOrganizationAdminAccountsResponse.Builder, ListOrganizationAdminAccountsResponse> {
    private static final SdkField<List<AdminAccount>> ADMIN_ACCOUNTS_FIELD = SdkField
            .<List<AdminAccount>> builder(MarshallingType.LIST)
            .memberName("AdminAccounts")
            .getter(getter(ListOrganizationAdminAccountsResponse::adminAccounts))
            .setter(setter(Builder::adminAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adminAccounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AdminAccount> builder(MarshallingType.SDK_POJO)
                                            .constructor(AdminAccount::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListOrganizationAdminAccountsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADMIN_ACCOUNTS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("adminAccounts", ADMIN_ACCOUNTS_FIELD);
                    put("nextToken", NEXT_TOKEN_FIELD);
                }
            });

    private final List<AdminAccount> adminAccounts;

    private final String nextToken;

    private ListOrganizationAdminAccountsResponse(BuilderImpl builder) {
        super(builder);
        this.adminAccounts = builder.adminAccounts;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdminAccounts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAdminAccounts() {
        return adminAccounts != null && !(adminAccounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of accounts configured as GuardDuty delegated administrators.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdminAccounts} method.
     * </p>
     * 
     * @return A list of accounts configured as GuardDuty delegated administrators.
     */
    public final List<AdminAccount> adminAccounts() {
        return adminAccounts;
    }

    /**
     * <p>
     * The pagination parameter to be used on the next list operation to retrieve more items.
     * </p>
     * 
     * @return The pagination parameter to be used on the next list operation to retrieve more items.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAdminAccounts() ? adminAccounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOrganizationAdminAccountsResponse)) {
            return false;
        }
        ListOrganizationAdminAccountsResponse other = (ListOrganizationAdminAccountsResponse) obj;
        return hasAdminAccounts() == other.hasAdminAccounts() && Objects.equals(adminAccounts(), other.adminAccounts())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListOrganizationAdminAccountsResponse")
                .add("AdminAccounts", hasAdminAccounts() ? adminAccounts() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdminAccounts":
            return Optional.ofNullable(clazz.cast(adminAccounts()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListOrganizationAdminAccountsResponse, T> g) {
        return obj -> g.apply((ListOrganizationAdminAccountsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GuardDutyResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListOrganizationAdminAccountsResponse> {
        /**
         * <p>
         * A list of accounts configured as GuardDuty delegated administrators.
         * </p>
         * 
         * @param adminAccounts
         *        A list of accounts configured as GuardDuty delegated administrators.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adminAccounts(Collection<AdminAccount> adminAccounts);

        /**
         * <p>
         * A list of accounts configured as GuardDuty delegated administrators.
         * </p>
         * 
         * @param adminAccounts
         *        A list of accounts configured as GuardDuty delegated administrators.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adminAccounts(AdminAccount... adminAccounts);

        /**
         * <p>
         * A list of accounts configured as GuardDuty delegated administrators.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.AdminAccount.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.guardduty.model.AdminAccount#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.AdminAccount.Builder#build()} is called immediately
         * and its result is passed to {@link #adminAccounts(List<AdminAccount>)}.
         * 
         * @param adminAccounts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.AdminAccount.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #adminAccounts(java.util.Collection<AdminAccount>)
         */
        Builder adminAccounts(Consumer<AdminAccount.Builder>... adminAccounts);

        /**
         * <p>
         * The pagination parameter to be used on the next list operation to retrieve more items.
         * </p>
         * 
         * @param nextToken
         *        The pagination parameter to be used on the next list operation to retrieve more items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GuardDutyResponse.BuilderImpl implements Builder {
        private List<AdminAccount> adminAccounts = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOrganizationAdminAccountsResponse model) {
            super(model);
            adminAccounts(model.adminAccounts);
            nextToken(model.nextToken);
        }

        public final List<AdminAccount.Builder> getAdminAccounts() {
            List<AdminAccount.Builder> result = AdminAccountsCopier.copyToBuilder(this.adminAccounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdminAccounts(Collection<AdminAccount.BuilderImpl> adminAccounts) {
            this.adminAccounts = AdminAccountsCopier.copyFromBuilder(adminAccounts);
        }

        @Override
        public final Builder adminAccounts(Collection<AdminAccount> adminAccounts) {
            this.adminAccounts = AdminAccountsCopier.copy(adminAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adminAccounts(AdminAccount... adminAccounts) {
            adminAccounts(Arrays.asList(adminAccounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adminAccounts(Consumer<AdminAccount.Builder>... adminAccounts) {
            adminAccounts(Stream.of(adminAccounts).map(c -> AdminAccount.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListOrganizationAdminAccountsResponse build() {
            return new ListOrganizationAdminAccountsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
