/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the network connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkConnection implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkConnection.Builder, NetworkConnection> {
    private static final SdkField<String> DIRECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Direction").getter(getter(NetworkConnection::directionAsString)).setter(setter(Builder::direction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("direction").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("direction", DIRECTION_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String direction;

    private NetworkConnection(BuilderImpl builder) {
        this.direction = builder.direction;
    }

    /**
     * <p>
     * The direction in which the network traffic is flowing.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #direction} will
     * return {@link NetworkDirection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #directionAsString}.
     * </p>
     * 
     * @return The direction in which the network traffic is flowing.
     * @see NetworkDirection
     */
    public final NetworkDirection direction() {
        return NetworkDirection.fromValue(direction);
    }

    /**
     * <p>
     * The direction in which the network traffic is flowing.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #direction} will
     * return {@link NetworkDirection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #directionAsString}.
     * </p>
     * 
     * @return The direction in which the network traffic is flowing.
     * @see NetworkDirection
     */
    public final String directionAsString() {
        return direction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(directionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkConnection)) {
            return false;
        }
        NetworkConnection other = (NetworkConnection) obj;
        return Objects.equals(directionAsString(), other.directionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkConnection").add("Direction", directionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Direction":
            return Optional.ofNullable(clazz.cast(directionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<NetworkConnection, T> g) {
        return obj -> g.apply((NetworkConnection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkConnection> {
        /**
         * <p>
         * The direction in which the network traffic is flowing.
         * </p>
         * 
         * @param direction
         *        The direction in which the network traffic is flowing.
         * @see NetworkDirection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkDirection
         */
        Builder direction(String direction);

        /**
         * <p>
         * The direction in which the network traffic is flowing.
         * </p>
         * 
         * @param direction
         *        The direction in which the network traffic is flowing.
         * @see NetworkDirection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkDirection
         */
        Builder direction(NetworkDirection direction);
    }

    static final class BuilderImpl implements Builder {
        private String direction;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkConnection model) {
            direction(model.direction);
        }

        public final String getDirection() {
            return direction;
        }

        public final void setDirection(String direction) {
            this.direction = direction;
        }

        @Override
        public final Builder direction(String direction) {
            this.direction = direction;
            return this;
        }

        @Override
        public final Builder direction(NetworkDirection direction) {
            this.direction(direction == null ? null : direction.toString());
            return this;
        }

        @Override
        public NetworkConnection build() {
            return new NetworkConnection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
