/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of features which will be configured for the organization.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OrganizationFeatureConfigurationResult implements SdkPojo, Serializable,
        ToCopyableBuilder<OrganizationFeatureConfigurationResult.Builder, OrganizationFeatureConfigurationResult> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(OrganizationFeatureConfigurationResult::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> AUTO_ENABLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoEnable").getter(getter(OrganizationFeatureConfigurationResult::autoEnableAsString))
            .setter(setter(Builder::autoEnable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoEnable").build()).build();

    private static final SdkField<List<OrganizationAdditionalConfigurationResult>> ADDITIONAL_CONFIGURATION_FIELD = SdkField
            .<List<OrganizationAdditionalConfigurationResult>> builder(MarshallingType.LIST)
            .memberName("AdditionalConfiguration")
            .getter(getter(OrganizationFeatureConfigurationResult::additionalConfiguration))
            .setter(setter(Builder::additionalConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalConfiguration").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OrganizationAdditionalConfigurationResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(OrganizationAdditionalConfigurationResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, AUTO_ENABLE_FIELD,
            ADDITIONAL_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("name", NAME_FIELD);
                    put("autoEnable", AUTO_ENABLE_FIELD);
                    put("additionalConfiguration", ADDITIONAL_CONFIGURATION_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String autoEnable;

    private final List<OrganizationAdditionalConfigurationResult> additionalConfiguration;

    private OrganizationFeatureConfigurationResult(BuilderImpl builder) {
        this.name = builder.name;
        this.autoEnable = builder.autoEnable;
        this.additionalConfiguration = builder.additionalConfiguration;
    }

    /**
     * <p>
     * The name of the feature that is configured for the member accounts within the organization.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link OrgFeature#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The name of the feature that is configured for the member accounts within the organization.
     * @see OrgFeature
     */
    public final OrgFeature name() {
        return OrgFeature.fromValue(name);
    }

    /**
     * <p>
     * The name of the feature that is configured for the member accounts within the organization.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link OrgFeature#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The name of the feature that is configured for the member accounts within the organization.
     * @see OrgFeature
     */
    public final String nameAsString() {
        return name;
    }

    /**
     * <p>
     * Describes the status of the feature that is configured for the member accounts within the organization.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NEW</code>: Indicates that when a new account joins the organization, they will have the feature enabled
     * automatically.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALL</code>: Indicates that all accounts in the organization have the feature enabled automatically. This
     * includes <code>NEW</code> accounts that join the organization and accounts that may have been suspended or
     * removed from the organization in GuardDuty.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NONE</code>: Indicates that the feature will not be automatically enabled for any account in the
     * organization. In this case, each account will be managed individually by the administrator.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoEnable} will
     * return {@link OrgFeatureStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #autoEnableAsString}.
     * </p>
     * 
     * @return Describes the status of the feature that is configured for the member accounts within the
     *         organization.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NEW</code>: Indicates that when a new account joins the organization, they will have the feature
     *         enabled automatically.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALL</code>: Indicates that all accounts in the organization have the feature enabled automatically.
     *         This includes <code>NEW</code> accounts that join the organization and accounts that may have been
     *         suspended or removed from the organization in GuardDuty.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NONE</code>: Indicates that the feature will not be automatically enabled for any account in the
     *         organization. In this case, each account will be managed individually by the administrator.
     *         </p>
     *         </li>
     * @see OrgFeatureStatus
     */
    public final OrgFeatureStatus autoEnable() {
        return OrgFeatureStatus.fromValue(autoEnable);
    }

    /**
     * <p>
     * Describes the status of the feature that is configured for the member accounts within the organization.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NEW</code>: Indicates that when a new account joins the organization, they will have the feature enabled
     * automatically.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALL</code>: Indicates that all accounts in the organization have the feature enabled automatically. This
     * includes <code>NEW</code> accounts that join the organization and accounts that may have been suspended or
     * removed from the organization in GuardDuty.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NONE</code>: Indicates that the feature will not be automatically enabled for any account in the
     * organization. In this case, each account will be managed individually by the administrator.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoEnable} will
     * return {@link OrgFeatureStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #autoEnableAsString}.
     * </p>
     * 
     * @return Describes the status of the feature that is configured for the member accounts within the
     *         organization.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NEW</code>: Indicates that when a new account joins the organization, they will have the feature
     *         enabled automatically.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALL</code>: Indicates that all accounts in the organization have the feature enabled automatically.
     *         This includes <code>NEW</code> accounts that join the organization and accounts that may have been
     *         suspended or removed from the organization in GuardDuty.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NONE</code>: Indicates that the feature will not be automatically enabled for any account in the
     *         organization. In this case, each account will be managed individually by the administrator.
     *         </p>
     *         </li>
     * @see OrgFeatureStatus
     */
    public final String autoEnableAsString() {
        return autoEnable;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalConfiguration property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAdditionalConfiguration() {
        return additionalConfiguration != null && !(additionalConfiguration instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The additional configuration that is configured for the member accounts within the organization.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalConfiguration} method.
     * </p>
     * 
     * @return The additional configuration that is configured for the member accounts within the organization.
     */
    public final List<OrganizationAdditionalConfigurationResult> additionalConfiguration() {
        return additionalConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(autoEnableAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalConfiguration() ? additionalConfiguration() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrganizationFeatureConfigurationResult)) {
            return false;
        }
        OrganizationFeatureConfigurationResult other = (OrganizationFeatureConfigurationResult) obj;
        return Objects.equals(nameAsString(), other.nameAsString())
                && Objects.equals(autoEnableAsString(), other.autoEnableAsString())
                && hasAdditionalConfiguration() == other.hasAdditionalConfiguration()
                && Objects.equals(additionalConfiguration(), other.additionalConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OrganizationFeatureConfigurationResult").add("Name", nameAsString())
                .add("AutoEnable", autoEnableAsString())
                .add("AdditionalConfiguration", hasAdditionalConfiguration() ? additionalConfiguration() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        case "AutoEnable":
            return Optional.ofNullable(clazz.cast(autoEnableAsString()));
        case "AdditionalConfiguration":
            return Optional.ofNullable(clazz.cast(additionalConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<OrganizationFeatureConfigurationResult, T> g) {
        return obj -> g.apply((OrganizationFeatureConfigurationResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OrganizationFeatureConfigurationResult> {
        /**
         * <p>
         * The name of the feature that is configured for the member accounts within the organization.
         * </p>
         * 
         * @param name
         *        The name of the feature that is configured for the member accounts within the organization.
         * @see OrgFeature
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrgFeature
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the feature that is configured for the member accounts within the organization.
         * </p>
         * 
         * @param name
         *        The name of the feature that is configured for the member accounts within the organization.
         * @see OrgFeature
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrgFeature
         */
        Builder name(OrgFeature name);

        /**
         * <p>
         * Describes the status of the feature that is configured for the member accounts within the organization.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NEW</code>: Indicates that when a new account joins the organization, they will have the feature
         * enabled automatically.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL</code>: Indicates that all accounts in the organization have the feature enabled automatically.
         * This includes <code>NEW</code> accounts that join the organization and accounts that may have been suspended
         * or removed from the organization in GuardDuty.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NONE</code>: Indicates that the feature will not be automatically enabled for any account in the
         * organization. In this case, each account will be managed individually by the administrator.
         * </p>
         * </li>
         * </ul>
         * 
         * @param autoEnable
         *        Describes the status of the feature that is configured for the member accounts within the
         *        organization.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NEW</code>: Indicates that when a new account joins the organization, they will have the feature
         *        enabled automatically.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL</code>: Indicates that all accounts in the organization have the feature enabled
         *        automatically. This includes <code>NEW</code> accounts that join the organization and accounts that
         *        may have been suspended or removed from the organization in GuardDuty.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NONE</code>: Indicates that the feature will not be automatically enabled for any account in the
         *        organization. In this case, each account will be managed individually by the administrator.
         *        </p>
         *        </li>
         * @see OrgFeatureStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrgFeatureStatus
         */
        Builder autoEnable(String autoEnable);

        /**
         * <p>
         * Describes the status of the feature that is configured for the member accounts within the organization.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NEW</code>: Indicates that when a new account joins the organization, they will have the feature
         * enabled automatically.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL</code>: Indicates that all accounts in the organization have the feature enabled automatically.
         * This includes <code>NEW</code> accounts that join the organization and accounts that may have been suspended
         * or removed from the organization in GuardDuty.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NONE</code>: Indicates that the feature will not be automatically enabled for any account in the
         * organization. In this case, each account will be managed individually by the administrator.
         * </p>
         * </li>
         * </ul>
         * 
         * @param autoEnable
         *        Describes the status of the feature that is configured for the member accounts within the
         *        organization.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NEW</code>: Indicates that when a new account joins the organization, they will have the feature
         *        enabled automatically.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL</code>: Indicates that all accounts in the organization have the feature enabled
         *        automatically. This includes <code>NEW</code> accounts that join the organization and accounts that
         *        may have been suspended or removed from the organization in GuardDuty.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NONE</code>: Indicates that the feature will not be automatically enabled for any account in the
         *        organization. In this case, each account will be managed individually by the administrator.
         *        </p>
         *        </li>
         * @see OrgFeatureStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrgFeatureStatus
         */
        Builder autoEnable(OrgFeatureStatus autoEnable);

        /**
         * <p>
         * The additional configuration that is configured for the member accounts within the organization.
         * </p>
         * 
         * @param additionalConfiguration
         *        The additional configuration that is configured for the member accounts within the organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalConfiguration(Collection<OrganizationAdditionalConfigurationResult> additionalConfiguration);

        /**
         * <p>
         * The additional configuration that is configured for the member accounts within the organization.
         * </p>
         * 
         * @param additionalConfiguration
         *        The additional configuration that is configured for the member accounts within the organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalConfiguration(OrganizationAdditionalConfigurationResult... additionalConfiguration);

        /**
         * <p>
         * The additional configuration that is configured for the member accounts within the organization.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.OrganizationAdditionalConfigurationResult.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.guardduty.model.OrganizationAdditionalConfigurationResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.OrganizationAdditionalConfigurationResult.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #additionalConfiguration(List<OrganizationAdditionalConfigurationResult>)}.
         * 
         * @param additionalConfiguration
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.OrganizationAdditionalConfigurationResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #additionalConfiguration(java.util.Collection<OrganizationAdditionalConfigurationResult>)
         */
        Builder additionalConfiguration(Consumer<OrganizationAdditionalConfigurationResult.Builder>... additionalConfiguration);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String autoEnable;

        private List<OrganizationAdditionalConfigurationResult> additionalConfiguration = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OrganizationFeatureConfigurationResult model) {
            name(model.name);
            autoEnable(model.autoEnable);
            additionalConfiguration(model.additionalConfiguration);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(OrgFeature name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final String getAutoEnable() {
            return autoEnable;
        }

        public final void setAutoEnable(String autoEnable) {
            this.autoEnable = autoEnable;
        }

        @Override
        public final Builder autoEnable(String autoEnable) {
            this.autoEnable = autoEnable;
            return this;
        }

        @Override
        public final Builder autoEnable(OrgFeatureStatus autoEnable) {
            this.autoEnable(autoEnable == null ? null : autoEnable.toString());
            return this;
        }

        public final List<OrganizationAdditionalConfigurationResult.Builder> getAdditionalConfiguration() {
            List<OrganizationAdditionalConfigurationResult.Builder> result = OrganizationAdditionalConfigurationResultsCopier
                    .copyToBuilder(this.additionalConfiguration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdditionalConfiguration(
                Collection<OrganizationAdditionalConfigurationResult.BuilderImpl> additionalConfiguration) {
            this.additionalConfiguration = OrganizationAdditionalConfigurationResultsCopier
                    .copyFromBuilder(additionalConfiguration);
        }

        @Override
        public final Builder additionalConfiguration(Collection<OrganizationAdditionalConfigurationResult> additionalConfiguration) {
            this.additionalConfiguration = OrganizationAdditionalConfigurationResultsCopier.copy(additionalConfiguration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalConfiguration(OrganizationAdditionalConfigurationResult... additionalConfiguration) {
            additionalConfiguration(Arrays.asList(additionalConfiguration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalConfiguration(
                Consumer<OrganizationAdditionalConfigurationResult.Builder>... additionalConfiguration) {
            additionalConfiguration(Stream.of(additionalConfiguration)
                    .map(c -> OrganizationAdditionalConfigurationResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public OrganizationFeatureConfigurationResult build() {
            return new OrganizationFeatureConfigurationResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
