/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Organization-wide Kubernetes data sources configurations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OrganizationKubernetesConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<OrganizationKubernetesConfiguration.Builder, OrganizationKubernetesConfiguration> {
    private static final SdkField<OrganizationKubernetesAuditLogsConfiguration> AUDIT_LOGS_FIELD = SdkField
            .<OrganizationKubernetesAuditLogsConfiguration> builder(MarshallingType.SDK_POJO).memberName("AuditLogs")
            .getter(getter(OrganizationKubernetesConfiguration::auditLogs)).setter(setter(Builder::auditLogs))
            .constructor(OrganizationKubernetesAuditLogsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("auditLogs").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIT_LOGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("auditLogs", AUDIT_LOGS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final OrganizationKubernetesAuditLogsConfiguration auditLogs;

    private OrganizationKubernetesConfiguration(BuilderImpl builder) {
        this.auditLogs = builder.auditLogs;
    }

    /**
     * <p>
     * Whether Kubernetes audit logs data source should be auto-enabled for new members joining the organization.
     * </p>
     * 
     * @return Whether Kubernetes audit logs data source should be auto-enabled for new members joining the
     *         organization.
     */
    public final OrganizationKubernetesAuditLogsConfiguration auditLogs() {
        return auditLogs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(auditLogs());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrganizationKubernetesConfiguration)) {
            return false;
        }
        OrganizationKubernetesConfiguration other = (OrganizationKubernetesConfiguration) obj;
        return Objects.equals(auditLogs(), other.auditLogs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OrganizationKubernetesConfiguration").add("AuditLogs", auditLogs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuditLogs":
            return Optional.ofNullable(clazz.cast(auditLogs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<OrganizationKubernetesConfiguration, T> g) {
        return obj -> g.apply((OrganizationKubernetesConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OrganizationKubernetesConfiguration> {
        /**
         * <p>
         * Whether Kubernetes audit logs data source should be auto-enabled for new members joining the organization.
         * </p>
         * 
         * @param auditLogs
         *        Whether Kubernetes audit logs data source should be auto-enabled for new members joining the
         *        organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auditLogs(OrganizationKubernetesAuditLogsConfiguration auditLogs);

        /**
         * <p>
         * Whether Kubernetes audit logs data source should be auto-enabled for new members joining the organization.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link OrganizationKubernetesAuditLogsConfiguration.Builder} avoiding the need to create one manually via
         * {@link OrganizationKubernetesAuditLogsConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OrganizationKubernetesAuditLogsConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #auditLogs(OrganizationKubernetesAuditLogsConfiguration)}.
         * 
         * @param auditLogs
         *        a consumer that will call methods on {@link OrganizationKubernetesAuditLogsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #auditLogs(OrganizationKubernetesAuditLogsConfiguration)
         */
        default Builder auditLogs(Consumer<OrganizationKubernetesAuditLogsConfiguration.Builder> auditLogs) {
            return auditLogs(OrganizationKubernetesAuditLogsConfiguration.builder().applyMutation(auditLogs).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private OrganizationKubernetesAuditLogsConfiguration auditLogs;

        private BuilderImpl() {
        }

        private BuilderImpl(OrganizationKubernetesConfiguration model) {
            auditLogs(model.auditLogs);
        }

        public final OrganizationKubernetesAuditLogsConfiguration.Builder getAuditLogs() {
            return auditLogs != null ? auditLogs.toBuilder() : null;
        }

        public final void setAuditLogs(OrganizationKubernetesAuditLogsConfiguration.BuilderImpl auditLogs) {
            this.auditLogs = auditLogs != null ? auditLogs.build() : null;
        }

        @Override
        public final Builder auditLogs(OrganizationKubernetesAuditLogsConfiguration auditLogs) {
            this.auditLogs = auditLogs;
            return this;
        }

        @Override
        public OrganizationKubernetesConfiguration build() {
            return new OrganizationKubernetesConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
