/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the coverage statistics of the features for the entire Amazon Web Services organization.
 * </p>
 * <p>
 * When you create a new Amazon Web Services organization, it might take up to 24 hours to generate the statistics
 * summary for this organization.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OrganizationStatistics implements SdkPojo, Serializable,
        ToCopyableBuilder<OrganizationStatistics.Builder, OrganizationStatistics> {
    private static final SdkField<Integer> TOTAL_ACCOUNTS_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalAccountsCount").getter(getter(OrganizationStatistics::totalAccountsCount))
            .setter(setter(Builder::totalAccountsCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalAccountsCount").build())
            .build();

    private static final SdkField<Integer> MEMBER_ACCOUNTS_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MemberAccountsCount").getter(getter(OrganizationStatistics::memberAccountsCount))
            .setter(setter(Builder::memberAccountsCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memberAccountsCount").build())
            .build();

    private static final SdkField<Integer> ACTIVE_ACCOUNTS_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ActiveAccountsCount").getter(getter(OrganizationStatistics::activeAccountsCount))
            .setter(setter(Builder::activeAccountsCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeAccountsCount").build())
            .build();

    private static final SdkField<Integer> ENABLED_ACCOUNTS_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EnabledAccountsCount").getter(getter(OrganizationStatistics::enabledAccountsCount))
            .setter(setter(Builder::enabledAccountsCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabledAccountsCount").build())
            .build();

    private static final SdkField<List<OrganizationFeatureStatistics>> COUNT_BY_FEATURE_FIELD = SdkField
            .<List<OrganizationFeatureStatistics>> builder(MarshallingType.LIST)
            .memberName("CountByFeature")
            .getter(getter(OrganizationStatistics::countByFeature))
            .setter(setter(Builder::countByFeature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("countByFeature").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OrganizationFeatureStatistics> builder(MarshallingType.SDK_POJO)
                                            .constructor(OrganizationFeatureStatistics::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_ACCOUNTS_COUNT_FIELD,
            MEMBER_ACCOUNTS_COUNT_FIELD, ACTIVE_ACCOUNTS_COUNT_FIELD, ENABLED_ACCOUNTS_COUNT_FIELD, COUNT_BY_FEATURE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("totalAccountsCount", TOTAL_ACCOUNTS_COUNT_FIELD);
                    put("memberAccountsCount", MEMBER_ACCOUNTS_COUNT_FIELD);
                    put("activeAccountsCount", ACTIVE_ACCOUNTS_COUNT_FIELD);
                    put("enabledAccountsCount", ENABLED_ACCOUNTS_COUNT_FIELD);
                    put("countByFeature", COUNT_BY_FEATURE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Integer totalAccountsCount;

    private final Integer memberAccountsCount;

    private final Integer activeAccountsCount;

    private final Integer enabledAccountsCount;

    private final List<OrganizationFeatureStatistics> countByFeature;

    private OrganizationStatistics(BuilderImpl builder) {
        this.totalAccountsCount = builder.totalAccountsCount;
        this.memberAccountsCount = builder.memberAccountsCount;
        this.activeAccountsCount = builder.activeAccountsCount;
        this.enabledAccountsCount = builder.enabledAccountsCount;
        this.countByFeature = builder.countByFeature;
    }

    /**
     * <p>
     * Total number of accounts in your Amazon Web Services organization.
     * </p>
     * 
     * @return Total number of accounts in your Amazon Web Services organization.
     */
    public final Integer totalAccountsCount() {
        return totalAccountsCount;
    }

    /**
     * <p>
     * Total number of accounts in your Amazon Web Services organization that are associated with GuardDuty.
     * </p>
     * 
     * @return Total number of accounts in your Amazon Web Services organization that are associated with GuardDuty.
     */
    public final Integer memberAccountsCount() {
        return memberAccountsCount;
    }

    /**
     * <p>
     * Total number of active accounts in your Amazon Web Services organization that are associated with GuardDuty.
     * </p>
     * 
     * @return Total number of active accounts in your Amazon Web Services organization that are associated with
     *         GuardDuty.
     */
    public final Integer activeAccountsCount() {
        return activeAccountsCount;
    }

    /**
     * <p>
     * Total number of accounts that have enabled GuardDuty.
     * </p>
     * 
     * @return Total number of accounts that have enabled GuardDuty.
     */
    public final Integer enabledAccountsCount() {
        return enabledAccountsCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the CountByFeature property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCountByFeature() {
        return countByFeature != null && !(countByFeature instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Retrieves the coverage statistics for each feature.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCountByFeature} method.
     * </p>
     * 
     * @return Retrieves the coverage statistics for each feature.
     */
    public final List<OrganizationFeatureStatistics> countByFeature() {
        return countByFeature;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(totalAccountsCount());
        hashCode = 31 * hashCode + Objects.hashCode(memberAccountsCount());
        hashCode = 31 * hashCode + Objects.hashCode(activeAccountsCount());
        hashCode = 31 * hashCode + Objects.hashCode(enabledAccountsCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasCountByFeature() ? countByFeature() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrganizationStatistics)) {
            return false;
        }
        OrganizationStatistics other = (OrganizationStatistics) obj;
        return Objects.equals(totalAccountsCount(), other.totalAccountsCount())
                && Objects.equals(memberAccountsCount(), other.memberAccountsCount())
                && Objects.equals(activeAccountsCount(), other.activeAccountsCount())
                && Objects.equals(enabledAccountsCount(), other.enabledAccountsCount())
                && hasCountByFeature() == other.hasCountByFeature() && Objects.equals(countByFeature(), other.countByFeature());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OrganizationStatistics").add("TotalAccountsCount", totalAccountsCount())
                .add("MemberAccountsCount", memberAccountsCount()).add("ActiveAccountsCount", activeAccountsCount())
                .add("EnabledAccountsCount", enabledAccountsCount())
                .add("CountByFeature", hasCountByFeature() ? countByFeature() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TotalAccountsCount":
            return Optional.ofNullable(clazz.cast(totalAccountsCount()));
        case "MemberAccountsCount":
            return Optional.ofNullable(clazz.cast(memberAccountsCount()));
        case "ActiveAccountsCount":
            return Optional.ofNullable(clazz.cast(activeAccountsCount()));
        case "EnabledAccountsCount":
            return Optional.ofNullable(clazz.cast(enabledAccountsCount()));
        case "CountByFeature":
            return Optional.ofNullable(clazz.cast(countByFeature()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<OrganizationStatistics, T> g) {
        return obj -> g.apply((OrganizationStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OrganizationStatistics> {
        /**
         * <p>
         * Total number of accounts in your Amazon Web Services organization.
         * </p>
         * 
         * @param totalAccountsCount
         *        Total number of accounts in your Amazon Web Services organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalAccountsCount(Integer totalAccountsCount);

        /**
         * <p>
         * Total number of accounts in your Amazon Web Services organization that are associated with GuardDuty.
         * </p>
         * 
         * @param memberAccountsCount
         *        Total number of accounts in your Amazon Web Services organization that are associated with GuardDuty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberAccountsCount(Integer memberAccountsCount);

        /**
         * <p>
         * Total number of active accounts in your Amazon Web Services organization that are associated with GuardDuty.
         * </p>
         * 
         * @param activeAccountsCount
         *        Total number of active accounts in your Amazon Web Services organization that are associated with
         *        GuardDuty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeAccountsCount(Integer activeAccountsCount);

        /**
         * <p>
         * Total number of accounts that have enabled GuardDuty.
         * </p>
         * 
         * @param enabledAccountsCount
         *        Total number of accounts that have enabled GuardDuty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledAccountsCount(Integer enabledAccountsCount);

        /**
         * <p>
         * Retrieves the coverage statistics for each feature.
         * </p>
         * 
         * @param countByFeature
         *        Retrieves the coverage statistics for each feature.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder countByFeature(Collection<OrganizationFeatureStatistics> countByFeature);

        /**
         * <p>
         * Retrieves the coverage statistics for each feature.
         * </p>
         * 
         * @param countByFeature
         *        Retrieves the coverage statistics for each feature.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder countByFeature(OrganizationFeatureStatistics... countByFeature);

        /**
         * <p>
         * Retrieves the coverage statistics for each feature.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.OrganizationFeatureStatistics.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.guardduty.model.OrganizationFeatureStatistics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.OrganizationFeatureStatistics.Builder#build()} is
         * called immediately and its result is passed to {@link #countByFeature(List<OrganizationFeatureStatistics>)}.
         * 
         * @param countByFeature
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.OrganizationFeatureStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #countByFeature(java.util.Collection<OrganizationFeatureStatistics>)
         */
        Builder countByFeature(Consumer<OrganizationFeatureStatistics.Builder>... countByFeature);
    }

    static final class BuilderImpl implements Builder {
        private Integer totalAccountsCount;

        private Integer memberAccountsCount;

        private Integer activeAccountsCount;

        private Integer enabledAccountsCount;

        private List<OrganizationFeatureStatistics> countByFeature = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OrganizationStatistics model) {
            totalAccountsCount(model.totalAccountsCount);
            memberAccountsCount(model.memberAccountsCount);
            activeAccountsCount(model.activeAccountsCount);
            enabledAccountsCount(model.enabledAccountsCount);
            countByFeature(model.countByFeature);
        }

        public final Integer getTotalAccountsCount() {
            return totalAccountsCount;
        }

        public final void setTotalAccountsCount(Integer totalAccountsCount) {
            this.totalAccountsCount = totalAccountsCount;
        }

        @Override
        public final Builder totalAccountsCount(Integer totalAccountsCount) {
            this.totalAccountsCount = totalAccountsCount;
            return this;
        }

        public final Integer getMemberAccountsCount() {
            return memberAccountsCount;
        }

        public final void setMemberAccountsCount(Integer memberAccountsCount) {
            this.memberAccountsCount = memberAccountsCount;
        }

        @Override
        public final Builder memberAccountsCount(Integer memberAccountsCount) {
            this.memberAccountsCount = memberAccountsCount;
            return this;
        }

        public final Integer getActiveAccountsCount() {
            return activeAccountsCount;
        }

        public final void setActiveAccountsCount(Integer activeAccountsCount) {
            this.activeAccountsCount = activeAccountsCount;
        }

        @Override
        public final Builder activeAccountsCount(Integer activeAccountsCount) {
            this.activeAccountsCount = activeAccountsCount;
            return this;
        }

        public final Integer getEnabledAccountsCount() {
            return enabledAccountsCount;
        }

        public final void setEnabledAccountsCount(Integer enabledAccountsCount) {
            this.enabledAccountsCount = enabledAccountsCount;
        }

        @Override
        public final Builder enabledAccountsCount(Integer enabledAccountsCount) {
            this.enabledAccountsCount = enabledAccountsCount;
            return this;
        }

        public final List<OrganizationFeatureStatistics.Builder> getCountByFeature() {
            List<OrganizationFeatureStatistics.Builder> result = OrganizationFeatureStatisticsResultsCopier
                    .copyToBuilder(this.countByFeature);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCountByFeature(Collection<OrganizationFeatureStatistics.BuilderImpl> countByFeature) {
            this.countByFeature = OrganizationFeatureStatisticsResultsCopier.copyFromBuilder(countByFeature);
        }

        @Override
        public final Builder countByFeature(Collection<OrganizationFeatureStatistics> countByFeature) {
            this.countByFeature = OrganizationFeatureStatisticsResultsCopier.copy(countByFeature);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder countByFeature(OrganizationFeatureStatistics... countByFeature) {
            countByFeature(Arrays.asList(countByFeature));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder countByFeature(Consumer<OrganizationFeatureStatistics.Builder>... countByFeature) {
            countByFeature(Stream.of(countByFeature).map(c -> OrganizationFeatureStatistics.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public OrganizationStatistics build() {
            return new OrganizationStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
