/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the public access policies that apply to the S3 bucket.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PublicAccess implements SdkPojo, Serializable, ToCopyableBuilder<PublicAccess.Builder, PublicAccess> {
    private static final SdkField<PermissionConfiguration> PERMISSION_CONFIGURATION_FIELD = SdkField
            .<PermissionConfiguration> builder(MarshallingType.SDK_POJO).memberName("PermissionConfiguration")
            .getter(getter(PublicAccess::permissionConfiguration)).setter(setter(Builder::permissionConfiguration))
            .constructor(PermissionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissionConfiguration").build())
            .build();

    private static final SdkField<String> EFFECTIVE_PERMISSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EffectivePermission").getter(getter(PublicAccess::effectivePermission))
            .setter(setter(Builder::effectivePermission))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("effectivePermission").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PERMISSION_CONFIGURATION_FIELD, EFFECTIVE_PERMISSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("permissionConfiguration", PERMISSION_CONFIGURATION_FIELD);
                    put("effectivePermission", EFFECTIVE_PERMISSION_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final PermissionConfiguration permissionConfiguration;

    private final String effectivePermission;

    private PublicAccess(BuilderImpl builder) {
        this.permissionConfiguration = builder.permissionConfiguration;
        this.effectivePermission = builder.effectivePermission;
    }

    /**
     * <p>
     * Contains information about how permissions are configured for the S3 bucket.
     * </p>
     * 
     * @return Contains information about how permissions are configured for the S3 bucket.
     */
    public final PermissionConfiguration permissionConfiguration() {
        return permissionConfiguration;
    }

    /**
     * <p>
     * Describes the effective permission on this bucket after factoring all attached policies.
     * </p>
     * 
     * @return Describes the effective permission on this bucket after factoring all attached policies.
     */
    public final String effectivePermission() {
        return effectivePermission;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(permissionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(effectivePermission());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublicAccess)) {
            return false;
        }
        PublicAccess other = (PublicAccess) obj;
        return Objects.equals(permissionConfiguration(), other.permissionConfiguration())
                && Objects.equals(effectivePermission(), other.effectivePermission());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PublicAccess").add("PermissionConfiguration", permissionConfiguration())
                .add("EffectivePermission", effectivePermission()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PermissionConfiguration":
            return Optional.ofNullable(clazz.cast(permissionConfiguration()));
        case "EffectivePermission":
            return Optional.ofNullable(clazz.cast(effectivePermission()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PublicAccess, T> g) {
        return obj -> g.apply((PublicAccess) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PublicAccess> {
        /**
         * <p>
         * Contains information about how permissions are configured for the S3 bucket.
         * </p>
         * 
         * @param permissionConfiguration
         *        Contains information about how permissions are configured for the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionConfiguration(PermissionConfiguration permissionConfiguration);

        /**
         * <p>
         * Contains information about how permissions are configured for the S3 bucket.
         * </p>
         * This is a convenience method that creates an instance of the {@link PermissionConfiguration.Builder} avoiding
         * the need to create one manually via {@link PermissionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PermissionConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #permissionConfiguration(PermissionConfiguration)}.
         * 
         * @param permissionConfiguration
         *        a consumer that will call methods on {@link PermissionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #permissionConfiguration(PermissionConfiguration)
         */
        default Builder permissionConfiguration(Consumer<PermissionConfiguration.Builder> permissionConfiguration) {
            return permissionConfiguration(PermissionConfiguration.builder().applyMutation(permissionConfiguration).build());
        }

        /**
         * <p>
         * Describes the effective permission on this bucket after factoring all attached policies.
         * </p>
         * 
         * @param effectivePermission
         *        Describes the effective permission on this bucket after factoring all attached policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder effectivePermission(String effectivePermission);
    }

    static final class BuilderImpl implements Builder {
        private PermissionConfiguration permissionConfiguration;

        private String effectivePermission;

        private BuilderImpl() {
        }

        private BuilderImpl(PublicAccess model) {
            permissionConfiguration(model.permissionConfiguration);
            effectivePermission(model.effectivePermission);
        }

        public final PermissionConfiguration.Builder getPermissionConfiguration() {
            return permissionConfiguration != null ? permissionConfiguration.toBuilder() : null;
        }

        public final void setPermissionConfiguration(PermissionConfiguration.BuilderImpl permissionConfiguration) {
            this.permissionConfiguration = permissionConfiguration != null ? permissionConfiguration.build() : null;
        }

        @Override
        public final Builder permissionConfiguration(PermissionConfiguration permissionConfiguration) {
            this.permissionConfiguration = permissionConfiguration;
            return this;
        }

        public final String getEffectivePermission() {
            return effectivePermission;
        }

        public final void setEffectivePermission(String effectivePermission) {
            this.effectivePermission = effectivePermission;
        }

        @Override
        public final Builder effectivePermission(String effectivePermission) {
            this.effectivePermission = effectivePermission;
            return this;
        }

        @Override
        public PublicAccess build() {
            return new PublicAccess(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
