/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the user and authentication details for a database instance involved in the finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RdsDbUserDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<RdsDbUserDetails.Builder, RdsDbUserDetails> {
    private static final SdkField<String> USER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("User")
            .getter(getter(RdsDbUserDetails::user)).setter(setter(Builder::user))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("user").build()).build();

    private static final SdkField<String> APPLICATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Application").getter(getter(RdsDbUserDetails::application)).setter(setter(Builder::application))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("application").build()).build();

    private static final SdkField<String> DATABASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Database").getter(getter(RdsDbUserDetails::database)).setter(setter(Builder::database))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("database").build()).build();

    private static final SdkField<String> SSL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Ssl")
            .getter(getter(RdsDbUserDetails::ssl)).setter(setter(Builder::ssl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ssl").build()).build();

    private static final SdkField<String> AUTH_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthMethod").getter(getter(RdsDbUserDetails::authMethod)).setter(setter(Builder::authMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authMethod").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_FIELD, APPLICATION_FIELD,
            DATABASE_FIELD, SSL_FIELD, AUTH_METHOD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("user", USER_FIELD);
                    put("application", APPLICATION_FIELD);
                    put("database", DATABASE_FIELD);
                    put("ssl", SSL_FIELD);
                    put("authMethod", AUTH_METHOD_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String user;

    private final String application;

    private final String database;

    private final String ssl;

    private final String authMethod;

    private RdsDbUserDetails(BuilderImpl builder) {
        this.user = builder.user;
        this.application = builder.application;
        this.database = builder.database;
        this.ssl = builder.ssl;
        this.authMethod = builder.authMethod;
    }

    /**
     * <p>
     * The user name used in the anomalous login attempt.
     * </p>
     * 
     * @return The user name used in the anomalous login attempt.
     */
    public final String user() {
        return user;
    }

    /**
     * <p>
     * The application name used in the anomalous login attempt.
     * </p>
     * 
     * @return The application name used in the anomalous login attempt.
     */
    public final String application() {
        return application;
    }

    /**
     * <p>
     * The name of the database instance involved in the anomalous login attempt.
     * </p>
     * 
     * @return The name of the database instance involved in the anomalous login attempt.
     */
    public final String database() {
        return database;
    }

    /**
     * <p>
     * The version of the Secure Socket Layer (SSL) used for the network.
     * </p>
     * 
     * @return The version of the Secure Socket Layer (SSL) used for the network.
     */
    public final String ssl() {
        return ssl;
    }

    /**
     * <p>
     * The authentication method used by the user involved in the finding.
     * </p>
     * 
     * @return The authentication method used by the user involved in the finding.
     */
    public final String authMethod() {
        return authMethod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(user());
        hashCode = 31 * hashCode + Objects.hashCode(application());
        hashCode = 31 * hashCode + Objects.hashCode(database());
        hashCode = 31 * hashCode + Objects.hashCode(ssl());
        hashCode = 31 * hashCode + Objects.hashCode(authMethod());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RdsDbUserDetails)) {
            return false;
        }
        RdsDbUserDetails other = (RdsDbUserDetails) obj;
        return Objects.equals(user(), other.user()) && Objects.equals(application(), other.application())
                && Objects.equals(database(), other.database()) && Objects.equals(ssl(), other.ssl())
                && Objects.equals(authMethod(), other.authMethod());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RdsDbUserDetails").add("User", user()).add("Application", application())
                .add("Database", database()).add("Ssl", ssl()).add("AuthMethod", authMethod()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "User":
            return Optional.ofNullable(clazz.cast(user()));
        case "Application":
            return Optional.ofNullable(clazz.cast(application()));
        case "Database":
            return Optional.ofNullable(clazz.cast(database()));
        case "Ssl":
            return Optional.ofNullable(clazz.cast(ssl()));
        case "AuthMethod":
            return Optional.ofNullable(clazz.cast(authMethod()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RdsDbUserDetails, T> g) {
        return obj -> g.apply((RdsDbUserDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RdsDbUserDetails> {
        /**
         * <p>
         * The user name used in the anomalous login attempt.
         * </p>
         * 
         * @param user
         *        The user name used in the anomalous login attempt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder user(String user);

        /**
         * <p>
         * The application name used in the anomalous login attempt.
         * </p>
         * 
         * @param application
         *        The application name used in the anomalous login attempt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder application(String application);

        /**
         * <p>
         * The name of the database instance involved in the anomalous login attempt.
         * </p>
         * 
         * @param database
         *        The name of the database instance involved in the anomalous login attempt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder database(String database);

        /**
         * <p>
         * The version of the Secure Socket Layer (SSL) used for the network.
         * </p>
         * 
         * @param ssl
         *        The version of the Secure Socket Layer (SSL) used for the network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ssl(String ssl);

        /**
         * <p>
         * The authentication method used by the user involved in the finding.
         * </p>
         * 
         * @param authMethod
         *        The authentication method used by the user involved in the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authMethod(String authMethod);
    }

    static final class BuilderImpl implements Builder {
        private String user;

        private String application;

        private String database;

        private String ssl;

        private String authMethod;

        private BuilderImpl() {
        }

        private BuilderImpl(RdsDbUserDetails model) {
            user(model.user);
            application(model.application);
            database(model.database);
            ssl(model.ssl);
            authMethod(model.authMethod);
        }

        public final String getUser() {
            return user;
        }

        public final void setUser(String user) {
            this.user = user;
        }

        @Override
        public final Builder user(String user) {
            this.user = user;
            return this;
        }

        public final String getApplication() {
            return application;
        }

        public final void setApplication(String application) {
            this.application = application;
        }

        @Override
        public final Builder application(String application) {
            this.application = application;
            return this;
        }

        public final String getDatabase() {
            return database;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final String getSsl() {
            return ssl;
        }

        public final void setSsl(String ssl) {
            this.ssl = ssl;
        }

        @Override
        public final Builder ssl(String ssl) {
            this.ssl = ssl;
            return this;
        }

        public final String getAuthMethod() {
            return authMethod;
        }

        public final void setAuthMethod(String authMethod) {
            this.authMethod = authMethod;
        }

        @Override
        public final Builder authMethod(String authMethod) {
            this.authMethod = authMethod;
            return this;
        }

        @Override
        public RdsDbUserDetails build() {
            return new RdsDbUserDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
