/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the resource type <code>RDSLimitlessDB</code> that is involved in a GuardDuty finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RdsLimitlessDbDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<RdsLimitlessDbDetails.Builder, RdsLimitlessDbDetails> {
    private static final SdkField<String> DB_SHARD_GROUP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DbShardGroupIdentifier").getter(getter(RdsLimitlessDbDetails::dbShardGroupIdentifier))
            .setter(setter(Builder::dbShardGroupIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbShardGroupIdentifier").build())
            .build();

    private static final SdkField<String> DB_SHARD_GROUP_RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DbShardGroupResourceId").getter(getter(RdsLimitlessDbDetails::dbShardGroupResourceId))
            .setter(setter(Builder::dbShardGroupResourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbShardGroupResourceId").build())
            .build();

    private static final SdkField<String> DB_SHARD_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DbShardGroupArn").getter(getter(RdsLimitlessDbDetails::dbShardGroupArn))
            .setter(setter(Builder::dbShardGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbShardGroupArn").build()).build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(RdsLimitlessDbDetails::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engine").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(RdsLimitlessDbDetails::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineVersion").build()).build();

    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DbClusterIdentifier").getter(getter(RdsLimitlessDbDetails::dbClusterIdentifier))
            .setter(setter(Builder::dbClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbClusterIdentifier").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(RdsLimitlessDbDetails::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DB_SHARD_GROUP_IDENTIFIER_FIELD, DB_SHARD_GROUP_RESOURCE_ID_FIELD, DB_SHARD_GROUP_ARN_FIELD, ENGINE_FIELD,
            ENGINE_VERSION_FIELD, DB_CLUSTER_IDENTIFIER_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("dbShardGroupIdentifier", DB_SHARD_GROUP_IDENTIFIER_FIELD);
                    put("dbShardGroupResourceId", DB_SHARD_GROUP_RESOURCE_ID_FIELD);
                    put("dbShardGroupArn", DB_SHARD_GROUP_ARN_FIELD);
                    put("engine", ENGINE_FIELD);
                    put("engineVersion", ENGINE_VERSION_FIELD);
                    put("dbClusterIdentifier", DB_CLUSTER_IDENTIFIER_FIELD);
                    put("tags", TAGS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String dbShardGroupIdentifier;

    private final String dbShardGroupResourceId;

    private final String dbShardGroupArn;

    private final String engine;

    private final String engineVersion;

    private final String dbClusterIdentifier;

    private final List<Tag> tags;

    private RdsLimitlessDbDetails(BuilderImpl builder) {
        this.dbShardGroupIdentifier = builder.dbShardGroupIdentifier;
        this.dbShardGroupResourceId = builder.dbShardGroupResourceId;
        this.dbShardGroupArn = builder.dbShardGroupArn;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name associated with the Limitless DB shard group.
     * </p>
     * 
     * @return The name associated with the Limitless DB shard group.
     */
    public final String dbShardGroupIdentifier() {
        return dbShardGroupIdentifier;
    }

    /**
     * <p>
     * The resource identifier of the DB shard group within the Limitless Database.
     * </p>
     * 
     * @return The resource identifier of the DB shard group within the Limitless Database.
     */
    public final String dbShardGroupResourceId() {
        return dbShardGroupResourceId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that identifies the DB shard group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that identifies the DB shard group.
     */
    public final String dbShardGroupArn() {
        return dbShardGroupArn;
    }

    /**
     * <p>
     * The database engine of the database instance involved in the finding.
     * </p>
     * 
     * @return The database engine of the database instance involved in the finding.
     */
    public final String engine() {
        return engine;
    }

    /**
     * <p>
     * The version of the database engine.
     * </p>
     * 
     * @return The version of the database engine.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The name of the database cluster that is a part of the Limitless Database.
     * </p>
     * 
     * @return The name of the database cluster that is a part of the Limitless Database.
     */
    public final String dbClusterIdentifier() {
        return dbClusterIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the tag key-value pair.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Information about the tag key-value pair.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dbShardGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(dbShardGroupResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(dbShardGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RdsLimitlessDbDetails)) {
            return false;
        }
        RdsLimitlessDbDetails other = (RdsLimitlessDbDetails) obj;
        return Objects.equals(dbShardGroupIdentifier(), other.dbShardGroupIdentifier())
                && Objects.equals(dbShardGroupResourceId(), other.dbShardGroupResourceId())
                && Objects.equals(dbShardGroupArn(), other.dbShardGroupArn()) && Objects.equals(engine(), other.engine())
                && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(dbClusterIdentifier(), other.dbClusterIdentifier()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RdsLimitlessDbDetails").add("DbShardGroupIdentifier", dbShardGroupIdentifier())
                .add("DbShardGroupResourceId", dbShardGroupResourceId()).add("DbShardGroupArn", dbShardGroupArn())
                .add("Engine", engine()).add("EngineVersion", engineVersion()).add("DbClusterIdentifier", dbClusterIdentifier())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DbShardGroupIdentifier":
            return Optional.ofNullable(clazz.cast(dbShardGroupIdentifier()));
        case "DbShardGroupResourceId":
            return Optional.ofNullable(clazz.cast(dbShardGroupResourceId()));
        case "DbShardGroupArn":
            return Optional.ofNullable(clazz.cast(dbShardGroupArn()));
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "DbClusterIdentifier":
            return Optional.ofNullable(clazz.cast(dbClusterIdentifier()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RdsLimitlessDbDetails, T> g) {
        return obj -> g.apply((RdsLimitlessDbDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RdsLimitlessDbDetails> {
        /**
         * <p>
         * The name associated with the Limitless DB shard group.
         * </p>
         * 
         * @param dbShardGroupIdentifier
         *        The name associated with the Limitless DB shard group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbShardGroupIdentifier(String dbShardGroupIdentifier);

        /**
         * <p>
         * The resource identifier of the DB shard group within the Limitless Database.
         * </p>
         * 
         * @param dbShardGroupResourceId
         *        The resource identifier of the DB shard group within the Limitless Database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbShardGroupResourceId(String dbShardGroupResourceId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that identifies the DB shard group.
         * </p>
         * 
         * @param dbShardGroupArn
         *        The Amazon Resource Name (ARN) that identifies the DB shard group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbShardGroupArn(String dbShardGroupArn);

        /**
         * <p>
         * The database engine of the database instance involved in the finding.
         * </p>
         * 
         * @param engine
         *        The database engine of the database instance involved in the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * The version of the database engine.
         * </p>
         * 
         * @param engineVersion
         *        The version of the database engine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * The name of the database cluster that is a part of the Limitless Database.
         * </p>
         * 
         * @param dbClusterIdentifier
         *        The name of the database cluster that is a part of the Limitless Database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterIdentifier(String dbClusterIdentifier);

        /**
         * <p>
         * Information about the tag key-value pair.
         * </p>
         * 
         * @param tags
         *        Information about the tag key-value pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Information about the tag key-value pair.
         * </p>
         * 
         * @param tags
         *        Information about the tag key-value pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Information about the tag key-value pair.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.guardduty.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String dbShardGroupIdentifier;

        private String dbShardGroupResourceId;

        private String dbShardGroupArn;

        private String engine;

        private String engineVersion;

        private String dbClusterIdentifier;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RdsLimitlessDbDetails model) {
            dbShardGroupIdentifier(model.dbShardGroupIdentifier);
            dbShardGroupResourceId(model.dbShardGroupResourceId);
            dbShardGroupArn(model.dbShardGroupArn);
            engine(model.engine);
            engineVersion(model.engineVersion);
            dbClusterIdentifier(model.dbClusterIdentifier);
            tags(model.tags);
        }

        public final String getDbShardGroupIdentifier() {
            return dbShardGroupIdentifier;
        }

        public final void setDbShardGroupIdentifier(String dbShardGroupIdentifier) {
            this.dbShardGroupIdentifier = dbShardGroupIdentifier;
        }

        @Override
        public final Builder dbShardGroupIdentifier(String dbShardGroupIdentifier) {
            this.dbShardGroupIdentifier = dbShardGroupIdentifier;
            return this;
        }

        public final String getDbShardGroupResourceId() {
            return dbShardGroupResourceId;
        }

        public final void setDbShardGroupResourceId(String dbShardGroupResourceId) {
            this.dbShardGroupResourceId = dbShardGroupResourceId;
        }

        @Override
        public final Builder dbShardGroupResourceId(String dbShardGroupResourceId) {
            this.dbShardGroupResourceId = dbShardGroupResourceId;
            return this;
        }

        public final String getDbShardGroupArn() {
            return dbShardGroupArn;
        }

        public final void setDbShardGroupArn(String dbShardGroupArn) {
            this.dbShardGroupArn = dbShardGroupArn;
        }

        @Override
        public final Builder dbShardGroupArn(String dbShardGroupArn) {
            this.dbShardGroupArn = dbShardGroupArn;
            return this;
        }

        public final String getEngine() {
            return engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getDbClusterIdentifier() {
            return dbClusterIdentifier;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public RdsLimitlessDbDetails build() {
            return new RdsLimitlessDbDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
