/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the remote port.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RemotePortDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<RemotePortDetails.Builder, RemotePortDetails> {
    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(RemotePortDetails::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()).build();

    private static final SdkField<String> PORT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PortName").getter(getter(RemotePortDetails::portName)).setter(setter(Builder::portName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORT_FIELD, PORT_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("port", PORT_FIELD);
                    put("portName", PORT_NAME_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Integer port;

    private final String portName;

    private RemotePortDetails(BuilderImpl builder) {
        this.port = builder.port;
        this.portName = builder.portName;
    }

    /**
     * <p>
     * The port number of the remote connection.
     * </p>
     * 
     * @return The port number of the remote connection.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The port name of the remote connection.
     * </p>
     * 
     * @return The port name of the remote connection.
     */
    public final String portName() {
        return portName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(portName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemotePortDetails)) {
            return false;
        }
        RemotePortDetails other = (RemotePortDetails) obj;
        return Objects.equals(port(), other.port()) && Objects.equals(portName(), other.portName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RemotePortDetails").add("Port", port()).add("PortName", portName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "PortName":
            return Optional.ofNullable(clazz.cast(portName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RemotePortDetails, T> g) {
        return obj -> g.apply((RemotePortDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RemotePortDetails> {
        /**
         * <p>
         * The port number of the remote connection.
         * </p>
         * 
         * @param port
         *        The port number of the remote connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The port name of the remote connection.
         * </p>
         * 
         * @param portName
         *        The port name of the remote connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portName(String portName);
    }

    static final class BuilderImpl implements Builder {
        private Integer port;

        private String portName;

        private BuilderImpl() {
        }

        private BuilderImpl(RemotePortDetails model) {
            port(model.port);
            portName(model.portName);
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getPortName() {
            return portName;
        }

        public final void setPortName(String portName) {
            this.portName = portName;
        }

        @Override
        public final Builder portName(String portName) {
            this.portName = portName;
            return this;
        }

        @Override
        public RemotePortDetails build() {
            return new RemotePortDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
