/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes whether S3 data event logs will be enabled as a data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3LogsConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<S3LogsConfiguration.Builder, S3LogsConfiguration> {
    private static final SdkField<Boolean> ENABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enable").getter(getter(S3LogsConfiguration::enable)).setter(setter(Builder::enable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enable").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("enable", ENABLE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Boolean enable;

    private S3LogsConfiguration(BuilderImpl builder) {
        this.enable = builder.enable;
    }

    /**
     * <p>
     * The status of S3 data event logs as a data source.
     * </p>
     * 
     * @return The status of S3 data event logs as a data source.
     */
    public final Boolean enable() {
        return enable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enable());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3LogsConfiguration)) {
            return false;
        }
        S3LogsConfiguration other = (S3LogsConfiguration) obj;
        return Objects.equals(enable(), other.enable());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3LogsConfiguration").add("Enable", enable()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Enable":
            return Optional.ofNullable(clazz.cast(enable()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<S3LogsConfiguration, T> g) {
        return obj -> g.apply((S3LogsConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3LogsConfiguration> {
        /**
         * <p>
         * The status of S3 data event logs as a data source.
         * </p>
         * 
         * @param enable
         *        The status of S3 data event logs as a data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enable(Boolean enable);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enable;

        private BuilderImpl() {
        }

        private BuilderImpl(S3LogsConfiguration model) {
            enable(model.enable);
        }

        public final Boolean getEnable() {
            return enable;
        }

        public final void setEnable(Boolean enable) {
            this.enable = enable;
        }

        @Override
        public final Builder enable(Boolean enable) {
            this.enable = enable;
            return this;
        }

        @Override
        public S3LogsConfiguration build() {
            return new S3LogsConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
