/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the result of the scan.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScanResultDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ScanResultDetails.Builder, ScanResultDetails> {
    private static final SdkField<String> SCAN_RESULT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScanResult").getter(getter(ScanResultDetails::scanResultAsString)).setter(setter(Builder::scanResult))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanResult").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCAN_RESULT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("scanResult", SCAN_RESULT_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String scanResult;

    private ScanResultDetails(BuilderImpl builder) {
        this.scanResult = builder.scanResult;
    }

    /**
     * <p>
     * An enum value representing possible scan results.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scanResult} will
     * return {@link ScanResult#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scanResultAsString}.
     * </p>
     * 
     * @return An enum value representing possible scan results.
     * @see ScanResult
     */
    public final ScanResult scanResult() {
        return ScanResult.fromValue(scanResult);
    }

    /**
     * <p>
     * An enum value representing possible scan results.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scanResult} will
     * return {@link ScanResult#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scanResultAsString}.
     * </p>
     * 
     * @return An enum value representing possible scan results.
     * @see ScanResult
     */
    public final String scanResultAsString() {
        return scanResult;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scanResultAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScanResultDetails)) {
            return false;
        }
        ScanResultDetails other = (ScanResultDetails) obj;
        return Objects.equals(scanResultAsString(), other.scanResultAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScanResultDetails").add("ScanResult", scanResultAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScanResult":
            return Optional.ofNullable(clazz.cast(scanResultAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ScanResultDetails, T> g) {
        return obj -> g.apply((ScanResultDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScanResultDetails> {
        /**
         * <p>
         * An enum value representing possible scan results.
         * </p>
         * 
         * @param scanResult
         *        An enum value representing possible scan results.
         * @see ScanResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanResult
         */
        Builder scanResult(String scanResult);

        /**
         * <p>
         * An enum value representing possible scan results.
         * </p>
         * 
         * @param scanResult
         *        An enum value representing possible scan results.
         * @see ScanResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanResult
         */
        Builder scanResult(ScanResult scanResult);
    }

    static final class BuilderImpl implements Builder {
        private String scanResult;

        private BuilderImpl() {
        }

        private BuilderImpl(ScanResultDetails model) {
            scanResult(model.scanResult);
        }

        public final String getScanResult() {
            return scanResult;
        }

        public final void setScanResult(String scanResult) {
            this.scanResult = scanResult;
        }

        @Override
        public final Builder scanResult(String scanResult) {
            this.scanResult = scanResult;
            return this;
        }

        @Override
        public final Builder scanResult(ScanResult scanResult) {
            this.scanResult(scanResult == null ? null : scanResult.toString());
            return this;
        }

        @Override
        public ScanResultDetails build() {
            return new ScanResultDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
