/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container security context.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SecurityContext implements SdkPojo, Serializable, ToCopyableBuilder<SecurityContext.Builder, SecurityContext> {
    private static final SdkField<Boolean> PRIVILEGED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Privileged").getter(getter(SecurityContext::privileged)).setter(setter(Builder::privileged))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privileged").build()).build();

    private static final SdkField<Boolean> ALLOW_PRIVILEGE_ESCALATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AllowPrivilegeEscalation").getter(getter(SecurityContext::allowPrivilegeEscalation))
            .setter(setter(Builder::allowPrivilegeEscalation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowPrivilegeEscalation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIVILEGED_FIELD,
            ALLOW_PRIVILEGE_ESCALATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("privileged", PRIVILEGED_FIELD);
                    put("allowPrivilegeEscalation", ALLOW_PRIVILEGE_ESCALATION_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Boolean privileged;

    private final Boolean allowPrivilegeEscalation;

    private SecurityContext(BuilderImpl builder) {
        this.privileged = builder.privileged;
        this.allowPrivilegeEscalation = builder.allowPrivilegeEscalation;
    }

    /**
     * <p>
     * Whether the container is privileged.
     * </p>
     * 
     * @return Whether the container is privileged.
     */
    public final Boolean privileged() {
        return privileged;
    }

    /**
     * <p>
     * Whether or not a container or a Kubernetes pod is allowed to gain more privileges than its parent process.
     * </p>
     * 
     * @return Whether or not a container or a Kubernetes pod is allowed to gain more privileges than its parent
     *         process.
     */
    public final Boolean allowPrivilegeEscalation() {
        return allowPrivilegeEscalation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(privileged());
        hashCode = 31 * hashCode + Objects.hashCode(allowPrivilegeEscalation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityContext)) {
            return false;
        }
        SecurityContext other = (SecurityContext) obj;
        return Objects.equals(privileged(), other.privileged())
                && Objects.equals(allowPrivilegeEscalation(), other.allowPrivilegeEscalation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SecurityContext").add("Privileged", privileged())
                .add("AllowPrivilegeEscalation", allowPrivilegeEscalation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Privileged":
            return Optional.ofNullable(clazz.cast(privileged()));
        case "AllowPrivilegeEscalation":
            return Optional.ofNullable(clazz.cast(allowPrivilegeEscalation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SecurityContext, T> g) {
        return obj -> g.apply((SecurityContext) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SecurityContext> {
        /**
         * <p>
         * Whether the container is privileged.
         * </p>
         * 
         * @param privileged
         *        Whether the container is privileged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privileged(Boolean privileged);

        /**
         * <p>
         * Whether or not a container or a Kubernetes pod is allowed to gain more privileges than its parent process.
         * </p>
         * 
         * @param allowPrivilegeEscalation
         *        Whether or not a container or a Kubernetes pod is allowed to gain more privileges than its parent
         *        process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowPrivilegeEscalation(Boolean allowPrivilegeEscalation);
    }

    static final class BuilderImpl implements Builder {
        private Boolean privileged;

        private Boolean allowPrivilegeEscalation;

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityContext model) {
            privileged(model.privileged);
            allowPrivilegeEscalation(model.allowPrivilegeEscalation);
        }

        public final Boolean getPrivileged() {
            return privileged;
        }

        public final void setPrivileged(Boolean privileged) {
            this.privileged = privileged;
        }

        @Override
        public final Builder privileged(Boolean privileged) {
            this.privileged = privileged;
            return this;
        }

        public final Boolean getAllowPrivilegeEscalation() {
            return allowPrivilegeEscalation;
        }

        public final void setAllowPrivilegeEscalation(Boolean allowPrivilegeEscalation) {
            this.allowPrivilegeEscalation = allowPrivilegeEscalation;
        }

        @Override
        public final Builder allowPrivilegeEscalation(Boolean allowPrivilegeEscalation) {
            this.allowPrivilegeEscalation = allowPrivilegeEscalation;
            return this;
        }

        @Override
        public SecurityContext build() {
            return new SecurityContext(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
