/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the criteria used to query usage statistics.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UsageCriteria implements SdkPojo, Serializable, ToCopyableBuilder<UsageCriteria.Builder, UsageCriteria> {
    private static final SdkField<List<String>> ACCOUNT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AccountIds")
            .getter(getter(UsageCriteria::accountIds))
            .setter(setter(Builder::accountIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> DATA_SOURCES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DataSources")
            .getter(getter(UsageCriteria::dataSourcesAsStrings))
            .setter(setter(Builder::dataSourcesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> RESOURCES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Resources")
            .getter(getter(UsageCriteria::resources))
            .setter(setter(Builder::resources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> FEATURES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Features")
            .getter(getter(UsageCriteria::featuresAsStrings))
            .setter(setter(Builder::featuresWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("features").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_IDS_FIELD,
            DATA_SOURCES_FIELD, RESOURCES_FIELD, FEATURES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("accountIds", ACCOUNT_IDS_FIELD);
                    put("dataSources", DATA_SOURCES_FIELD);
                    put("resources", RESOURCES_FIELD);
                    put("features", FEATURES_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final List<String> accountIds;

    private final List<String> dataSources;

    private final List<String> resources;

    private final List<String> features;

    private UsageCriteria(BuilderImpl builder) {
        this.accountIds = builder.accountIds;
        this.dataSources = builder.dataSources;
        this.resources = builder.resources;
        this.features = builder.features;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccountIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAccountIds() {
        return accountIds != null && !(accountIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The account IDs to aggregate usage statistics from.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccountIds} method.
     * </p>
     * 
     * @return The account IDs to aggregate usage statistics from.
     */
    public final List<String> accountIds() {
        return accountIds;
    }

    /**
     * <p>
     * The data sources to aggregate usage statistics from.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataSources} method.
     * </p>
     * 
     * @return The data sources to aggregate usage statistics from.
     * @deprecated This parameter is deprecated, use Features instead
     */
    @Deprecated
    public final List<DataSource> dataSources() {
        return DataSourceListCopier.copyStringToEnum(dataSources);
    }

    /**
     * For responses, this returns true if the service returned a value for the DataSources property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     *
     * @deprecated This parameter is deprecated, use Features instead
     */
    @Deprecated
    public final boolean hasDataSources() {
        return dataSources != null && !(dataSources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The data sources to aggregate usage statistics from.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataSources} method.
     * </p>
     * 
     * @return The data sources to aggregate usage statistics from.
     * @deprecated This parameter is deprecated, use Features instead
     */
    @Deprecated
    public final List<String> dataSourcesAsStrings() {
        return dataSources;
    }

    /**
     * For responses, this returns true if the service returned a value for the Resources property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasResources() {
        return resources != null && !(resources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The resources to aggregate usage statistics from. Only accepts exact resource names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResources} method.
     * </p>
     * 
     * @return The resources to aggregate usage statistics from. Only accepts exact resource names.
     */
    public final List<String> resources() {
        return resources;
    }

    /**
     * <p>
     * The features to aggregate usage statistics from.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFeatures} method.
     * </p>
     * 
     * @return The features to aggregate usage statistics from.
     */
    public final List<UsageFeature> features() {
        return UsageFeatureListCopier.copyStringToEnum(features);
    }

    /**
     * For responses, this returns true if the service returned a value for the Features property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFeatures() {
        return features != null && !(features instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The features to aggregate usage statistics from.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFeatures} method.
     * </p>
     * 
     * @return The features to aggregate usage statistics from.
     */
    public final List<String> featuresAsStrings() {
        return features;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAccountIds() ? accountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDataSources() ? dataSourcesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResources() ? resources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFeatures() ? featuresAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UsageCriteria)) {
            return false;
        }
        UsageCriteria other = (UsageCriteria) obj;
        return hasAccountIds() == other.hasAccountIds() && Objects.equals(accountIds(), other.accountIds())
                && hasDataSources() == other.hasDataSources()
                && Objects.equals(dataSourcesAsStrings(), other.dataSourcesAsStrings()) && hasResources() == other.hasResources()
                && Objects.equals(resources(), other.resources()) && hasFeatures() == other.hasFeatures()
                && Objects.equals(featuresAsStrings(), other.featuresAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UsageCriteria").add("AccountIds", hasAccountIds() ? accountIds() : null)
                .add("DataSources", hasDataSources() ? dataSourcesAsStrings() : null)
                .add("Resources", hasResources() ? resources() : null)
                .add("Features", hasFeatures() ? featuresAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountIds":
            return Optional.ofNullable(clazz.cast(accountIds()));
        case "DataSources":
            return Optional.ofNullable(clazz.cast(dataSourcesAsStrings()));
        case "Resources":
            return Optional.ofNullable(clazz.cast(resources()));
        case "Features":
            return Optional.ofNullable(clazz.cast(featuresAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UsageCriteria, T> g) {
        return obj -> g.apply((UsageCriteria) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UsageCriteria> {
        /**
         * <p>
         * The account IDs to aggregate usage statistics from.
         * </p>
         * 
         * @param accountIds
         *        The account IDs to aggregate usage statistics from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(Collection<String> accountIds);

        /**
         * <p>
         * The account IDs to aggregate usage statistics from.
         * </p>
         * 
         * @param accountIds
         *        The account IDs to aggregate usage statistics from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(String... accountIds);

        /**
         * <p>
         * The data sources to aggregate usage statistics from.
         * </p>
         * 
         * @param dataSources
         *        The data sources to aggregate usage statistics from.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated This parameter is deprecated, use Features instead
         */
        @Deprecated
        Builder dataSourcesWithStrings(Collection<String> dataSources);

        /**
         * <p>
         * The data sources to aggregate usage statistics from.
         * </p>
         * 
         * @param dataSources
         *        The data sources to aggregate usage statistics from.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated This parameter is deprecated, use Features instead
         */
        @Deprecated
        Builder dataSourcesWithStrings(String... dataSources);

        /**
         * <p>
         * The data sources to aggregate usage statistics from.
         * </p>
         * 
         * @param dataSources
         *        The data sources to aggregate usage statistics from.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated This parameter is deprecated, use Features instead
         */
        @Deprecated
        Builder dataSources(Collection<DataSource> dataSources);

        /**
         * <p>
         * The data sources to aggregate usage statistics from.
         * </p>
         * 
         * @param dataSources
         *        The data sources to aggregate usage statistics from.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated This parameter is deprecated, use Features instead
         */
        @Deprecated
        Builder dataSources(DataSource... dataSources);

        /**
         * <p>
         * The resources to aggregate usage statistics from. Only accepts exact resource names.
         * </p>
         * 
         * @param resources
         *        The resources to aggregate usage statistics from. Only accepts exact resource names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(Collection<String> resources);

        /**
         * <p>
         * The resources to aggregate usage statistics from. Only accepts exact resource names.
         * </p>
         * 
         * @param resources
         *        The resources to aggregate usage statistics from. Only accepts exact resource names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(String... resources);

        /**
         * <p>
         * The features to aggregate usage statistics from.
         * </p>
         * 
         * @param features
         *        The features to aggregate usage statistics from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featuresWithStrings(Collection<String> features);

        /**
         * <p>
         * The features to aggregate usage statistics from.
         * </p>
         * 
         * @param features
         *        The features to aggregate usage statistics from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featuresWithStrings(String... features);

        /**
         * <p>
         * The features to aggregate usage statistics from.
         * </p>
         * 
         * @param features
         *        The features to aggregate usage statistics from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder features(Collection<UsageFeature> features);

        /**
         * <p>
         * The features to aggregate usage statistics from.
         * </p>
         * 
         * @param features
         *        The features to aggregate usage statistics from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder features(UsageFeature... features);
    }

    static final class BuilderImpl implements Builder {
        private List<String> accountIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> dataSources = DefaultSdkAutoConstructList.getInstance();

        private List<String> resources = DefaultSdkAutoConstructList.getInstance();

        private List<String> features = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UsageCriteria model) {
            accountIds(model.accountIds);
            dataSourcesWithStrings(model.dataSources);
            resources(model.resources);
            featuresWithStrings(model.features);
        }

        public final Collection<String> getAccountIds() {
            if (accountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return accountIds;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdsCopier.copy(accountIds);
        }

        @Override
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdsCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(String... accountIds) {
            accountIds(Arrays.asList(accountIds));
            return this;
        }

        @Deprecated
        public final Collection<String> getDataSources() {
            if (dataSources instanceof SdkAutoConstructList) {
                return null;
            }
            return dataSources;
        }

        @Deprecated
        public final void setDataSources(Collection<String> dataSources) {
            this.dataSources = DataSourceListCopier.copy(dataSources);
        }

        @Override
        @Deprecated
        public final Builder dataSourcesWithStrings(Collection<String> dataSources) {
            this.dataSources = DataSourceListCopier.copy(dataSources);
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder dataSourcesWithStrings(String... dataSources) {
            dataSourcesWithStrings(Arrays.asList(dataSources));
            return this;
        }

        @Override
        @Deprecated
        public final Builder dataSources(Collection<DataSource> dataSources) {
            this.dataSources = DataSourceListCopier.copyEnumToString(dataSources);
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder dataSources(DataSource... dataSources) {
            dataSources(Arrays.asList(dataSources));
            return this;
        }

        public final Collection<String> getResources() {
            if (resources instanceof SdkAutoConstructList) {
                return null;
            }
            return resources;
        }

        public final void setResources(Collection<String> resources) {
            this.resources = ResourceListCopier.copy(resources);
        }

        @Override
        public final Builder resources(Collection<String> resources) {
            this.resources = ResourceListCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(String... resources) {
            resources(Arrays.asList(resources));
            return this;
        }

        public final Collection<String> getFeatures() {
            if (features instanceof SdkAutoConstructList) {
                return null;
            }
            return features;
        }

        public final void setFeatures(Collection<String> features) {
            this.features = UsageFeatureListCopier.copy(features);
        }

        @Override
        public final Builder featuresWithStrings(Collection<String> features) {
            this.features = UsageFeatureListCopier.copy(features);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featuresWithStrings(String... features) {
            featuresWithStrings(Arrays.asList(features));
            return this;
        }

        @Override
        public final Builder features(Collection<UsageFeature> features) {
            this.features = UsageFeatureListCopier.copyEnumToString(features);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder features(UsageFeature... features) {
            features(Arrays.asList(features));
            return this;
        }

        @Override
        public UsageCriteria build() {
            return new UsageCriteria(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
