/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the result of the total usage based on the feature.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UsageFeatureResult implements SdkPojo, Serializable,
        ToCopyableBuilder<UsageFeatureResult.Builder, UsageFeatureResult> {
    private static final SdkField<String> FEATURE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Feature")
            .getter(getter(UsageFeatureResult::featureAsString)).setter(setter(Builder::feature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("feature").build()).build();

    private static final SdkField<Total> TOTAL_FIELD = SdkField.<Total> builder(MarshallingType.SDK_POJO).memberName("Total")
            .getter(getter(UsageFeatureResult::total)).setter(setter(Builder::total)).constructor(Total::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("total").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURE_FIELD, TOTAL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("feature", FEATURE_FIELD);
                    put("total", TOTAL_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String feature;

    private final Total total;

    private UsageFeatureResult(BuilderImpl builder) {
        this.feature = builder.feature;
        this.total = builder.total;
    }

    /**
     * <p>
     * The feature that generated the usage cost.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #feature} will
     * return {@link UsageFeature#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #featureAsString}.
     * </p>
     * 
     * @return The feature that generated the usage cost.
     * @see UsageFeature
     */
    public final UsageFeature feature() {
        return UsageFeature.fromValue(feature);
    }

    /**
     * <p>
     * The feature that generated the usage cost.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #feature} will
     * return {@link UsageFeature#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #featureAsString}.
     * </p>
     * 
     * @return The feature that generated the usage cost.
     * @see UsageFeature
     */
    public final String featureAsString() {
        return feature;
    }

    /**
     * Returns the value of the Total property for this object.
     * 
     * @return The value of the Total property for this object.
     */
    public final Total total() {
        return total;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(featureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(total());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UsageFeatureResult)) {
            return false;
        }
        UsageFeatureResult other = (UsageFeatureResult) obj;
        return Objects.equals(featureAsString(), other.featureAsString()) && Objects.equals(total(), other.total());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UsageFeatureResult").add("Feature", featureAsString()).add("Total", total()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Feature":
            return Optional.ofNullable(clazz.cast(featureAsString()));
        case "Total":
            return Optional.ofNullable(clazz.cast(total()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UsageFeatureResult, T> g) {
        return obj -> g.apply((UsageFeatureResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UsageFeatureResult> {
        /**
         * <p>
         * The feature that generated the usage cost.
         * </p>
         * 
         * @param feature
         *        The feature that generated the usage cost.
         * @see UsageFeature
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsageFeature
         */
        Builder feature(String feature);

        /**
         * <p>
         * The feature that generated the usage cost.
         * </p>
         * 
         * @param feature
         *        The feature that generated the usage cost.
         * @see UsageFeature
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsageFeature
         */
        Builder feature(UsageFeature feature);

        /**
         * Sets the value of the Total property for this object.
         *
         * @param total
         *        The new value for the Total property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder total(Total total);

        /**
         * Sets the value of the Total property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Total.Builder} avoiding the need to
         * create one manually via {@link Total#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Total.Builder#build()} is called immediately and its result is
         * passed to {@link #total(Total)}.
         * 
         * @param total
         *        a consumer that will call methods on {@link Total.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #total(Total)
         */
        default Builder total(Consumer<Total.Builder> total) {
            return total(Total.builder().applyMutation(total).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String feature;

        private Total total;

        private BuilderImpl() {
        }

        private BuilderImpl(UsageFeatureResult model) {
            feature(model.feature);
            total(model.total);
        }

        public final String getFeature() {
            return feature;
        }

        public final void setFeature(String feature) {
            this.feature = feature;
        }

        @Override
        public final Builder feature(String feature) {
            this.feature = feature;
            return this;
        }

        @Override
        public final Builder feature(UsageFeature feature) {
            this.feature(feature == null ? null : feature.toString());
            return this;
        }

        public final Total.Builder getTotal() {
            return total != null ? total.toBuilder() : null;
        }

        public final void setTotal(Total.BuilderImpl total) {
            this.total = total != null ? total.build() : null;
        }

        @Override
        public final Builder total(Total total) {
            this.total = total;
            return this;
        }

        @Override
        public UsageFeatureResult build() {
            return new UsageFeatureResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
