/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information on the total of usage based on the topmost 50 account IDs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UsageTopAccountResult implements SdkPojo, Serializable,
        ToCopyableBuilder<UsageTopAccountResult.Builder, UsageTopAccountResult> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(UsageTopAccountResult::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<Total> TOTAL_FIELD = SdkField.<Total> builder(MarshallingType.SDK_POJO).memberName("Total")
            .getter(getter(UsageTopAccountResult::total)).setter(setter(Builder::total)).constructor(Total::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("total").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, TOTAL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("accountId", ACCOUNT_ID_FIELD);
                    put("total", TOTAL_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final Total total;

    private UsageTopAccountResult(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.total = builder.total;
    }

    /**
     * <p>
     * The unique account ID.
     * </p>
     * 
     * @return The unique account ID.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * Returns the value of the Total property for this object.
     * 
     * @return The value of the Total property for this object.
     */
    public final Total total() {
        return total;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(total());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UsageTopAccountResult)) {
            return false;
        }
        UsageTopAccountResult other = (UsageTopAccountResult) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(total(), other.total());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UsageTopAccountResult").add("AccountId", accountId()).add("Total", total()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "Total":
            return Optional.ofNullable(clazz.cast(total()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UsageTopAccountResult, T> g) {
        return obj -> g.apply((UsageTopAccountResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UsageTopAccountResult> {
        /**
         * <p>
         * The unique account ID.
         * </p>
         * 
         * @param accountId
         *        The unique account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * Sets the value of the Total property for this object.
         *
         * @param total
         *        The new value for the Total property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder total(Total total);

        /**
         * Sets the value of the Total property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Total.Builder} avoiding the need to
         * create one manually via {@link Total#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Total.Builder#build()} is called immediately and its result is
         * passed to {@link #total(Total)}.
         * 
         * @param total
         *        a consumer that will call methods on {@link Total.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #total(Total)
         */
        default Builder total(Consumer<Total.Builder> total) {
            return total(Total.builder().applyMutation(total).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private Total total;

        private BuilderImpl() {
        }

        private BuilderImpl(UsageTopAccountResult model) {
            accountId(model.accountId);
            total(model.total);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final Total.Builder getTotal() {
            return total != null ? total.toBuilder() : null;
        }

        public final void setTotal(Total.BuilderImpl total) {
            this.total = total != null ? total.build() : null;
        }

        @Override
        public final Builder total(Total total) {
            this.total = total;
            return this;
        }

        @Override
        public UsageTopAccountResult build() {
            return new UsageTopAccountResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
