/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the user involved in the attack sequence.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class User implements SdkPojo, Serializable, ToCopyableBuilder<User.Builder, User> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(User::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> UID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Uid")
            .getter(getter(User::uid)).setter(setter(Builder::uid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uid").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(User::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> CREDENTIAL_UID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CredentialUid").getter(getter(User::credentialUid)).setter(setter(Builder::credentialUid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialUid").build()).build();

    private static final SdkField<Account> ACCOUNT_FIELD = SdkField.<Account> builder(MarshallingType.SDK_POJO)
            .memberName("Account").getter(getter(User::account)).setter(setter(Builder::account)).constructor(Account::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("account").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, UID_FIELD,
            TYPE_FIELD, CREDENTIAL_UID_FIELD, ACCOUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("name", NAME_FIELD);
                    put("uid", UID_FIELD);
                    put("type", TYPE_FIELD);
                    put("credentialUid", CREDENTIAL_UID_FIELD);
                    put("account", ACCOUNT_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String uid;

    private final String type;

    private final String credentialUid;

    private final Account account;

    private User(BuilderImpl builder) {
        this.name = builder.name;
        this.uid = builder.uid;
        this.type = builder.type;
        this.credentialUid = builder.credentialUid;
        this.account = builder.account;
    }

    /**
     * <p>
     * The name of the user.
     * </p>
     * 
     * @return The name of the user.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The unique identifier of the user.
     * </p>
     * 
     * @return The unique identifier of the user.
     */
    public final String uid() {
        return uid;
    }

    /**
     * <p>
     * The type of the user.
     * </p>
     * 
     * @return The type of the user.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The credentials of the user ID.
     * </p>
     * 
     * @return The credentials of the user ID.
     */
    public final String credentialUid() {
        return credentialUid;
    }

    /**
     * <p>
     * Contains information about the Amazon Web Services account.
     * </p>
     * 
     * @return Contains information about the Amazon Web Services account.
     */
    public final Account account() {
        return account;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(uid());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(credentialUid());
        hashCode = 31 * hashCode + Objects.hashCode(account());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof User)) {
            return false;
        }
        User other = (User) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(uid(), other.uid()) && Objects.equals(type(), other.type())
                && Objects.equals(credentialUid(), other.credentialUid()) && Objects.equals(account(), other.account());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("User").add("Name", name()).add("Uid", uid()).add("Type", type())
                .add("CredentialUid", credentialUid()).add("Account", account()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Uid":
            return Optional.ofNullable(clazz.cast(uid()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "CredentialUid":
            return Optional.ofNullable(clazz.cast(credentialUid()));
        case "Account":
            return Optional.ofNullable(clazz.cast(account()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<User, T> g) {
        return obj -> g.apply((User) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, User> {
        /**
         * <p>
         * The name of the user.
         * </p>
         * 
         * @param name
         *        The name of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The unique identifier of the user.
         * </p>
         * 
         * @param uid
         *        The unique identifier of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uid(String uid);

        /**
         * <p>
         * The type of the user.
         * </p>
         * 
         * @param type
         *        The type of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The credentials of the user ID.
         * </p>
         * 
         * @param credentialUid
         *        The credentials of the user ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentialUid(String credentialUid);

        /**
         * <p>
         * Contains information about the Amazon Web Services account.
         * </p>
         * 
         * @param account
         *        Contains information about the Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder account(Account account);

        /**
         * <p>
         * Contains information about the Amazon Web Services account.
         * </p>
         * This is a convenience method that creates an instance of the {@link Account.Builder} avoiding the need to
         * create one manually via {@link Account#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Account.Builder#build()} is called immediately and its result is
         * passed to {@link #account(Account)}.
         * 
         * @param account
         *        a consumer that will call methods on {@link Account.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #account(Account)
         */
        default Builder account(Consumer<Account.Builder> account) {
            return account(Account.builder().applyMutation(account).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String uid;

        private String type;

        private String credentialUid;

        private Account account;

        private BuilderImpl() {
        }

        private BuilderImpl(User model) {
            name(model.name);
            uid(model.uid);
            type(model.type);
            credentialUid(model.credentialUid);
            account(model.account);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getUid() {
            return uid;
        }

        public final void setUid(String uid) {
            this.uid = uid;
        }

        @Override
        public final Builder uid(String uid) {
            this.uid = uid;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getCredentialUid() {
            return credentialUid;
        }

        public final void setCredentialUid(String credentialUid) {
            this.credentialUid = credentialUid;
        }

        @Override
        public final Builder credentialUid(String credentialUid) {
            this.credentialUid = credentialUid;
            return this;
        }

        public final Account.Builder getAccount() {
            return account != null ? account.toBuilder() : null;
        }

        public final void setAccount(Account.BuilderImpl account) {
            this.account = account != null ? account.build() : null;
        }

        @Override
        public final Builder account(Account account) {
            this.account = account;
            return this;
        }

        @Override
        public User build() {
            return new User(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
