/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.guardduty.model.CreateProtectedResource;
import software.amazon.awssdk.services.guardduty.model.GuardDutyRequest;
import software.amazon.awssdk.services.guardduty.model.MalwareProtectionPlanActions;
import software.amazon.awssdk.services.guardduty.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMalwareProtectionPlanRequest
extends GuardDutyRequest
implements ToCopyableBuilder<Builder, CreateMalwareProtectionPlanRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateMalwareProtectionPlanRequest.getter(CreateMalwareProtectionPlanRequest::clientToken)).setter(CreateMalwareProtectionPlanRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Role").getter(CreateMalwareProtectionPlanRequest.getter(CreateMalwareProtectionPlanRequest::role)).setter(CreateMalwareProtectionPlanRequest.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("role").build()}).build();
    private static final SdkField<CreateProtectedResource> PROTECTED_RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProtectedResource").getter(CreateMalwareProtectionPlanRequest.getter(CreateMalwareProtectionPlanRequest::protectedResource)).setter(CreateMalwareProtectionPlanRequest.setter(Builder::protectedResource)).constructor(CreateProtectedResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protectedResource").build()}).build();
    private static final SdkField<MalwareProtectionPlanActions> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Actions").getter(CreateMalwareProtectionPlanRequest.getter(CreateMalwareProtectionPlanRequest::actions)).setter(CreateMalwareProtectionPlanRequest.setter(Builder::actions)).constructor(MalwareProtectionPlanActions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateMalwareProtectionPlanRequest.getter(CreateMalwareProtectionPlanRequest::tags)).setter(CreateMalwareProtectionPlanRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, ROLE_FIELD, PROTECTED_RESOURCE_FIELD, ACTIONS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("clientToken", CLIENT_TOKEN_FIELD);
            this.put("role", ROLE_FIELD);
            this.put("protectedResource", PROTECTED_RESOURCE_FIELD);
            this.put("actions", ACTIONS_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private final String clientToken;
    private final String role;
    private final CreateProtectedResource protectedResource;
    private final MalwareProtectionPlanActions actions;
    private final Map<String, String> tags;

    private CreateMalwareProtectionPlanRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.role = builder.role;
        this.protectedResource = builder.protectedResource;
        this.actions = builder.actions;
        this.tags = builder.tags;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String role() {
        return this.role;
    }

    public final CreateProtectedResource protectedResource() {
        return this.protectedResource;
    }

    public final MalwareProtectionPlanActions actions() {
        return this.actions;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.role());
        hashCode = 31 * hashCode + Objects.hashCode(this.protectedResource());
        hashCode = 31 * hashCode + Objects.hashCode(this.actions());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMalwareProtectionPlanRequest)) {
            return false;
        }
        CreateMalwareProtectionPlanRequest other = (CreateMalwareProtectionPlanRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.role(), other.role()) && Objects.equals(this.protectedResource(), other.protectedResource()) && Objects.equals(this.actions(), other.actions()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateMalwareProtectionPlanRequest").add("ClientToken", (Object)this.clientToken()).add("Role", (Object)this.role()).add("ProtectedResource", (Object)this.protectedResource()).add("Actions", (Object)this.actions()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.role()));
            }
            case "ProtectedResource": {
                return Optional.ofNullable(clazz.cast(this.protectedResource()));
            }
            case "Actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateMalwareProtectionPlanRequest, T> g) {
        return obj -> g.apply((CreateMalwareProtectionPlanRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GuardDutyRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String role;
        private CreateProtectedResource protectedResource;
        private MalwareProtectionPlanActions actions;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMalwareProtectionPlanRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.role(model.role);
            this.protectedResource(model.protectedResource);
            this.actions(model.actions);
            this.tags(model.tags);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getRole() {
            return this.role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final CreateProtectedResource.Builder getProtectedResource() {
            return this.protectedResource != null ? this.protectedResource.toBuilder() : null;
        }

        public final void setProtectedResource(CreateProtectedResource.BuilderImpl protectedResource) {
            this.protectedResource = protectedResource != null ? protectedResource.build() : null;
        }

        @Override
        public final Builder protectedResource(CreateProtectedResource protectedResource) {
            this.protectedResource = protectedResource;
            return this;
        }

        public final MalwareProtectionPlanActions.Builder getActions() {
            return this.actions != null ? this.actions.toBuilder() : null;
        }

        public final void setActions(MalwareProtectionPlanActions.BuilderImpl actions) {
            this.actions = actions != null ? actions.build() : null;
        }

        @Override
        public final Builder actions(MalwareProtectionPlanActions actions) {
            this.actions = actions;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMalwareProtectionPlanRequest build() {
            return new CreateMalwareProtectionPlanRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GuardDutyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateMalwareProtectionPlanRequest> {
        public Builder clientToken(String var1);

        public Builder role(String var1);

        public Builder protectedResource(CreateProtectedResource var1);

        default public Builder protectedResource(Consumer<CreateProtectedResource.Builder> protectedResource) {
            return this.protectedResource((CreateProtectedResource)((CreateProtectedResource.Builder)CreateProtectedResource.builder().applyMutation(protectedResource)).build());
        }

        public Builder actions(MalwareProtectionPlanActions var1);

        default public Builder actions(Consumer<MalwareProtectionPlanActions.Builder> actions) {
            return this.actions((MalwareProtectionPlanActions)((MalwareProtectionPlanActions.Builder)MalwareProtectionPlanActions.builder().applyMutation(actions)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

