/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.EcsTaskDetails;
import software.amazon.awssdk.services.guardduty.model.Tag;
import software.amazon.awssdk.services.guardduty.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EcsClusterDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EcsClusterDetails> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(EcsClusterDetails.getter(EcsClusterDetails::name)).setter(EcsClusterDetails.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(EcsClusterDetails.getter(EcsClusterDetails::arn)).setter(EcsClusterDetails.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(EcsClusterDetails.getter(EcsClusterDetails::status)).setter(EcsClusterDetails.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Integer> ACTIVE_SERVICES_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ActiveServicesCount").getter(EcsClusterDetails.getter(EcsClusterDetails::activeServicesCount)).setter(EcsClusterDetails.setter(Builder::activeServicesCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeServicesCount").build()}).build();
    private static final SdkField<Integer> REGISTERED_CONTAINER_INSTANCES_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RegisteredContainerInstancesCount").getter(EcsClusterDetails.getter(EcsClusterDetails::registeredContainerInstancesCount)).setter(EcsClusterDetails.setter(Builder::registeredContainerInstancesCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registeredContainerInstancesCount").build()}).build();
    private static final SdkField<Integer> RUNNING_TASKS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RunningTasksCount").getter(EcsClusterDetails.getter(EcsClusterDetails::runningTasksCount)).setter(EcsClusterDetails.setter(Builder::runningTasksCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runningTasksCount").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(EcsClusterDetails.getter(EcsClusterDetails::tags)).setter(EcsClusterDetails.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<EcsTaskDetails> TASK_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TaskDetails").getter(EcsClusterDetails.getter(EcsClusterDetails::taskDetails)).setter(EcsClusterDetails.setter(Builder::taskDetails)).constructor(EcsTaskDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD, STATUS_FIELD, ACTIVE_SERVICES_COUNT_FIELD, REGISTERED_CONTAINER_INSTANCES_COUNT_FIELD, RUNNING_TASKS_COUNT_FIELD, TAGS_FIELD, TASK_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("name", NAME_FIELD);
            this.put("arn", ARN_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("activeServicesCount", ACTIVE_SERVICES_COUNT_FIELD);
            this.put("registeredContainerInstancesCount", REGISTERED_CONTAINER_INSTANCES_COUNT_FIELD);
            this.put("runningTasksCount", RUNNING_TASKS_COUNT_FIELD);
            this.put("tags", TAGS_FIELD);
            this.put("taskDetails", TASK_DETAILS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String arn;
    private final String status;
    private final Integer activeServicesCount;
    private final Integer registeredContainerInstancesCount;
    private final Integer runningTasksCount;
    private final List<Tag> tags;
    private final EcsTaskDetails taskDetails;

    private EcsClusterDetails(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.status = builder.status;
        this.activeServicesCount = builder.activeServicesCount;
        this.registeredContainerInstancesCount = builder.registeredContainerInstancesCount;
        this.runningTasksCount = builder.runningTasksCount;
        this.tags = builder.tags;
        this.taskDetails = builder.taskDetails;
    }

    public final String name() {
        return this.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final String status() {
        return this.status;
    }

    public final Integer activeServicesCount() {
        return this.activeServicesCount;
    }

    public final Integer registeredContainerInstancesCount() {
        return this.registeredContainerInstancesCount;
    }

    public final Integer runningTasksCount() {
        return this.runningTasksCount;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final EcsTaskDetails taskDetails() {
        return this.taskDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.activeServicesCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.registeredContainerInstancesCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.runningTasksCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.taskDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EcsClusterDetails)) {
            return false;
        }
        EcsClusterDetails other = (EcsClusterDetails)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.activeServicesCount(), other.activeServicesCount()) && Objects.equals(this.registeredContainerInstancesCount(), other.registeredContainerInstancesCount()) && Objects.equals(this.runningTasksCount(), other.runningTasksCount()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.taskDetails(), other.taskDetails());
    }

    public final String toString() {
        return ToString.builder((String)"EcsClusterDetails").add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("Status", (Object)this.status()).add("ActiveServicesCount", (Object)this.activeServicesCount()).add("RegisteredContainerInstancesCount", (Object)this.registeredContainerInstancesCount()).add("RunningTasksCount", (Object)this.runningTasksCount()).add("Tags", this.hasTags() ? this.tags() : null).add("TaskDetails", (Object)this.taskDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "ActiveServicesCount": {
                return Optional.ofNullable(clazz.cast(this.activeServicesCount()));
            }
            case "RegisteredContainerInstancesCount": {
                return Optional.ofNullable(clazz.cast(this.registeredContainerInstancesCount()));
            }
            case "RunningTasksCount": {
                return Optional.ofNullable(clazz.cast(this.runningTasksCount()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "TaskDetails": {
                return Optional.ofNullable(clazz.cast(this.taskDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EcsClusterDetails, T> g) {
        return obj -> g.apply((EcsClusterDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private String status;
        private Integer activeServicesCount;
        private Integer registeredContainerInstancesCount;
        private Integer runningTasksCount;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private EcsTaskDetails taskDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(EcsClusterDetails model) {
            this.name(model.name);
            this.arn(model.arn);
            this.status(model.status);
            this.activeServicesCount(model.activeServicesCount);
            this.registeredContainerInstancesCount(model.registeredContainerInstancesCount);
            this.runningTasksCount(model.runningTasksCount);
            this.tags(model.tags);
            this.taskDetails(model.taskDetails);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Integer getActiveServicesCount() {
            return this.activeServicesCount;
        }

        public final void setActiveServicesCount(Integer activeServicesCount) {
            this.activeServicesCount = activeServicesCount;
        }

        @Override
        public final Builder activeServicesCount(Integer activeServicesCount) {
            this.activeServicesCount = activeServicesCount;
            return this;
        }

        public final Integer getRegisteredContainerInstancesCount() {
            return this.registeredContainerInstancesCount;
        }

        public final void setRegisteredContainerInstancesCount(Integer registeredContainerInstancesCount) {
            this.registeredContainerInstancesCount = registeredContainerInstancesCount;
        }

        @Override
        public final Builder registeredContainerInstancesCount(Integer registeredContainerInstancesCount) {
            this.registeredContainerInstancesCount = registeredContainerInstancesCount;
            return this;
        }

        public final Integer getRunningTasksCount() {
            return this.runningTasksCount;
        }

        public final void setRunningTasksCount(Integer runningTasksCount) {
            this.runningTasksCount = runningTasksCount;
        }

        @Override
        public final Builder runningTasksCount(Integer runningTasksCount) {
            this.runningTasksCount = runningTasksCount;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final EcsTaskDetails.Builder getTaskDetails() {
            return this.taskDetails != null ? this.taskDetails.toBuilder() : null;
        }

        public final void setTaskDetails(EcsTaskDetails.BuilderImpl taskDetails) {
            this.taskDetails = taskDetails != null ? taskDetails.build() : null;
        }

        @Override
        public final Builder taskDetails(EcsTaskDetails taskDetails) {
            this.taskDetails = taskDetails;
            return this;
        }

        public EcsClusterDetails build() {
            return new EcsClusterDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EcsClusterDetails> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder status(String var1);

        public Builder activeServicesCount(Integer var1);

        public Builder registeredContainerInstancesCount(Integer var1);

        public Builder runningTasksCount(Integer var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder taskDetails(EcsTaskDetails var1);

        default public Builder taskDetails(Consumer<EcsTaskDetails.Builder> taskDetails) {
            return this.taskDetails((EcsTaskDetails)((EcsTaskDetails.Builder)EcsTaskDetails.builder().applyMutation(taskDetails)).build());
        }
    }
}

