/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.GroupsCopier;
import software.amazon.awssdk.services.guardduty.model.ImpersonatedUser;
import software.amazon.awssdk.services.guardduty.model.SessionNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KubernetesUserDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KubernetesUserDetails> {
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Username").getter(KubernetesUserDetails.getter(KubernetesUserDetails::username)).setter(KubernetesUserDetails.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("username").build()}).build();
    private static final SdkField<String> UID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Uid").getter(KubernetesUserDetails.getter(KubernetesUserDetails::uid)).setter(KubernetesUserDetails.setter(Builder::uid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uid").build()}).build();
    private static final SdkField<List<String>> GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Groups").getter(KubernetesUserDetails.getter(KubernetesUserDetails::groups)).setter(KubernetesUserDetails.setter(Builder::groups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SESSION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SessionName").getter(KubernetesUserDetails.getter(KubernetesUserDetails::sessionName)).setter(KubernetesUserDetails.setter(Builder::sessionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionName").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ImpersonatedUser> IMPERSONATED_USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ImpersonatedUser").getter(KubernetesUserDetails.getter(KubernetesUserDetails::impersonatedUser)).setter(KubernetesUserDetails.setter(Builder::impersonatedUser)).constructor(ImpersonatedUser::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("impersonatedUser").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USERNAME_FIELD, UID_FIELD, GROUPS_FIELD, SESSION_NAME_FIELD, IMPERSONATED_USER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("username", USERNAME_FIELD);
            this.put("uid", UID_FIELD);
            this.put("groups", GROUPS_FIELD);
            this.put("sessionName", SESSION_NAME_FIELD);
            this.put("impersonatedUser", IMPERSONATED_USER_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String username;
    private final String uid;
    private final List<String> groups;
    private final List<String> sessionName;
    private final ImpersonatedUser impersonatedUser;

    private KubernetesUserDetails(BuilderImpl builder) {
        this.username = builder.username;
        this.uid = builder.uid;
        this.groups = builder.groups;
        this.sessionName = builder.sessionName;
        this.impersonatedUser = builder.impersonatedUser;
    }

    public final String username() {
        return this.username;
    }

    public final String uid() {
        return this.uid;
    }

    public final boolean hasGroups() {
        return this.groups != null && !(this.groups instanceof SdkAutoConstructList);
    }

    public final List<String> groups() {
        return this.groups;
    }

    public final boolean hasSessionName() {
        return this.sessionName != null && !(this.sessionName instanceof SdkAutoConstructList);
    }

    public final List<String> sessionName() {
        return this.sessionName;
    }

    public final ImpersonatedUser impersonatedUser() {
        return this.impersonatedUser;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.uid());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroups() ? this.groups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSessionName() ? this.sessionName() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.impersonatedUser());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KubernetesUserDetails)) {
            return false;
        }
        KubernetesUserDetails other = (KubernetesUserDetails)obj;
        return Objects.equals(this.username(), other.username()) && Objects.equals(this.uid(), other.uid()) && this.hasGroups() == other.hasGroups() && Objects.equals(this.groups(), other.groups()) && this.hasSessionName() == other.hasSessionName() && Objects.equals(this.sessionName(), other.sessionName()) && Objects.equals(this.impersonatedUser(), other.impersonatedUser());
    }

    public final String toString() {
        return ToString.builder((String)"KubernetesUserDetails").add("Username", (Object)this.username()).add("Uid", (Object)this.uid()).add("Groups", this.hasGroups() ? this.groups() : null).add("SessionName", this.hasSessionName() ? this.sessionName() : null).add("ImpersonatedUser", (Object)this.impersonatedUser()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "Uid": {
                return Optional.ofNullable(clazz.cast(this.uid()));
            }
            case "Groups": {
                return Optional.ofNullable(clazz.cast(this.groups()));
            }
            case "SessionName": {
                return Optional.ofNullable(clazz.cast(this.sessionName()));
            }
            case "ImpersonatedUser": {
                return Optional.ofNullable(clazz.cast(this.impersonatedUser()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<KubernetesUserDetails, T> g) {
        return obj -> g.apply((KubernetesUserDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String username;
        private String uid;
        private List<String> groups = DefaultSdkAutoConstructList.getInstance();
        private List<String> sessionName = DefaultSdkAutoConstructList.getInstance();
        private ImpersonatedUser impersonatedUser;

        private BuilderImpl() {
        }

        private BuilderImpl(KubernetesUserDetails model) {
            this.username(model.username);
            this.uid(model.uid);
            this.groups(model.groups);
            this.sessionName(model.sessionName);
            this.impersonatedUser(model.impersonatedUser);
        }

        public final String getUsername() {
            return this.username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final String getUid() {
            return this.uid;
        }

        public final void setUid(String uid) {
            this.uid = uid;
        }

        @Override
        public final Builder uid(String uid) {
            this.uid = uid;
            return this;
        }

        public final Collection<String> getGroups() {
            if (this.groups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.groups;
        }

        public final void setGroups(Collection<String> groups) {
            this.groups = GroupsCopier.copy(groups);
        }

        @Override
        public final Builder groups(Collection<String> groups) {
            this.groups = GroupsCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(String ... groups) {
            this.groups(Arrays.asList(groups));
            return this;
        }

        public final Collection<String> getSessionName() {
            if (this.sessionName instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sessionName;
        }

        public final void setSessionName(Collection<String> sessionName) {
            this.sessionName = SessionNameListCopier.copy(sessionName);
        }

        @Override
        public final Builder sessionName(Collection<String> sessionName) {
            this.sessionName = SessionNameListCopier.copy(sessionName);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sessionName(String ... sessionName) {
            this.sessionName(Arrays.asList(sessionName));
            return this;
        }

        public final ImpersonatedUser.Builder getImpersonatedUser() {
            return this.impersonatedUser != null ? this.impersonatedUser.toBuilder() : null;
        }

        public final void setImpersonatedUser(ImpersonatedUser.BuilderImpl impersonatedUser) {
            this.impersonatedUser = impersonatedUser != null ? impersonatedUser.build() : null;
        }

        @Override
        public final Builder impersonatedUser(ImpersonatedUser impersonatedUser) {
            this.impersonatedUser = impersonatedUser;
            return this;
        }

        public KubernetesUserDetails build() {
            return new KubernetesUserDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KubernetesUserDetails> {
        public Builder username(String var1);

        public Builder uid(String var1);

        public Builder groups(Collection<String> var1);

        public Builder groups(String ... var1);

        public Builder sessionName(Collection<String> var1);

        public Builder sessionName(String ... var1);

        public Builder impersonatedUser(ImpersonatedUser var1);

        default public Builder impersonatedUser(Consumer<ImpersonatedUser.Builder> impersonatedUser) {
            return this.impersonatedUser((ImpersonatedUser)((ImpersonatedUser.Builder)ImpersonatedUser.builder().applyMutation(impersonatedUser)).build());
        }
    }
}

