/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VolumeMount
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VolumeMount> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(VolumeMount.getter(VolumeMount::name)).setter(VolumeMount.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> MOUNT_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MountPath").getter(VolumeMount.getter(VolumeMount::mountPath)).setter(VolumeMount.setter(Builder::mountPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mountPath").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, MOUNT_PATH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("name", NAME_FIELD);
            this.put("mountPath", MOUNT_PATH_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String mountPath;

    private VolumeMount(BuilderImpl builder) {
        this.name = builder.name;
        this.mountPath = builder.mountPath;
    }

    public final String name() {
        return this.name;
    }

    public final String mountPath() {
        return this.mountPath;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.mountPath());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeMount)) {
            return false;
        }
        VolumeMount other = (VolumeMount)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.mountPath(), other.mountPath());
    }

    public final String toString() {
        return ToString.builder((String)"VolumeMount").add("Name", (Object)this.name()).add("MountPath", (Object)this.mountPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "MountPath": {
                return Optional.ofNullable(clazz.cast(this.mountPath()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<VolumeMount, T> g) {
        return obj -> g.apply((VolumeMount)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String mountPath;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeMount model) {
            this.name(model.name);
            this.mountPath(model.mountPath);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getMountPath() {
            return this.mountPath;
        }

        public final void setMountPath(String mountPath) {
            this.mountPath = mountPath;
        }

        @Override
        public final Builder mountPath(String mountPath) {
            this.mountPath = mountPath;
            return this;
        }

        public VolumeMount build() {
            return new VolumeMount(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VolumeMount> {
        public Builder name(String var1);

        public Builder mountPath(String var1);
    }
}

