/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.health.HealthClient;
import software.amazon.awssdk.services.health.internal.UserAgentUtils;
import software.amazon.awssdk.services.health.model.DescribeEventAggregatesRequest;
import software.amazon.awssdk.services.health.model.DescribeEventAggregatesResponse;
import software.amazon.awssdk.services.health.model.EventAggregate;

public class DescribeEventAggregatesIterable
implements SdkIterable<DescribeEventAggregatesResponse> {
    private final HealthClient client;
    private final DescribeEventAggregatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeEventAggregatesIterable(HealthClient client, DescribeEventAggregatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeEventAggregatesResponseFetcher();
    }

    public Iterator<DescribeEventAggregatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EventAggregate> eventAggregates() {
        Function<DescribeEventAggregatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.eventAggregates() != null) {
                return response.eventAggregates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeEventAggregatesResponseFetcher
    implements SyncPageFetcher<DescribeEventAggregatesResponse> {
        private DescribeEventAggregatesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEventAggregatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeEventAggregatesResponse nextPage(DescribeEventAggregatesResponse previousPage) {
            if (previousPage == null) {
                return DescribeEventAggregatesIterable.this.client.describeEventAggregates(DescribeEventAggregatesIterable.this.firstRequest);
            }
            return DescribeEventAggregatesIterable.this.client.describeEventAggregates((DescribeEventAggregatesRequest)((Object)DescribeEventAggregatesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

