/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.policybuilder.iam.internal;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import software.amazon.awssdk.annotations.NotNull;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.policybuilder.iam.IamCondition;
import software.amazon.awssdk.policybuilder.iam.IamConditionOperator;
import software.amazon.awssdk.policybuilder.iam.IamPolicy;
import software.amazon.awssdk.policybuilder.iam.IamPolicyWriter;
import software.amazon.awssdk.policybuilder.iam.IamPrincipal;
import software.amazon.awssdk.policybuilder.iam.IamPrincipalType;
import software.amazon.awssdk.policybuilder.iam.IamStatement;
import software.amazon.awssdk.policybuilder.iam.IamValue;
import software.amazon.awssdk.protocols.jsoncore.JsonNodeParser;
import software.amazon.awssdk.protocols.jsoncore.JsonWriter;
import software.amazon.awssdk.thirdparty.jackson.core.JsonGenerator;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultIamPolicyWriter
implements IamPolicyWriter {
    private static final IamPolicyWriter INSTANCE = (IamPolicyWriter)IamPolicyWriter.builder().build();
    private final Boolean prettyPrint;
    @NotNull
    private final transient JsonWriter.JsonGeneratorFactory jsonGeneratorFactory;

    public DefaultIamPolicyWriter(Builder builder) {
        this.prettyPrint = builder.prettyPrint;
        this.jsonGeneratorFactory = Boolean.TRUE.equals(builder.prettyPrint) ? os -> {
            JsonGenerator generator = JsonNodeParser.DEFAULT_JSON_FACTORY.createGenerator(os);
            generator.useDefaultPrettyPrinter();
            return generator;
        } : null;
    }

    public static IamPolicyWriter create() {
        return INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String writeToString(IamPolicy policy) {
        return new String(this.writeToBytes(policy), StandardCharsets.UTF_8);
    }

    @Override
    public byte[] writeToBytes(IamPolicy policy) {
        return this.writePolicy(policy).getBytes();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultIamPolicyWriter that = (DefaultIamPolicyWriter)o;
        return Objects.equals(this.prettyPrint, that.prettyPrint);
    }

    public int hashCode() {
        return this.prettyPrint != null ? this.prettyPrint.hashCode() : 0;
    }

    private JsonWriter writePolicy(IamPolicy policy) {
        JsonWriter writer = JsonWriter.builder().jsonGeneratorFactory(this.jsonGeneratorFactory).build();
        writer.writeStartObject();
        this.writeFieldIfNotNull(writer, "Version", policy.version());
        this.writeFieldIfNotNull(writer, "Id", policy.id());
        this.writeStatements(writer, policy.statements());
        writer.writeEndObject();
        return writer;
    }

    private void writeStatements(JsonWriter writer, List<IamStatement> statements) {
        if (statements.isEmpty()) {
            return;
        }
        writer.writeFieldName("Statement");
        if (statements.size() == 1) {
            this.writeStatement(writer, statements.get(0));
            return;
        }
        writer.writeStartArray();
        statements.forEach(statement -> this.writeStatement(writer, (IamStatement)statement));
        writer.writeEndArray();
    }

    private void writeStatement(JsonWriter writer, IamStatement statement) {
        writer.writeStartObject();
        this.writeFieldIfNotNull(writer, "Sid", statement.sid());
        this.writeFieldIfNotNull(writer, "Effect", statement.effect());
        this.writePrincipals(writer, "Principal", statement.principals());
        this.writePrincipals(writer, "NotPrincipal", statement.notPrincipals());
        this.writeValueArrayField(writer, "Action", statement.actions());
        this.writeValueArrayField(writer, "NotAction", statement.notActions());
        this.writeValueArrayField(writer, "Resource", statement.resources());
        this.writeValueArrayField(writer, "NotResource", statement.notResources());
        this.writeConditions(writer, statement.conditions());
        writer.writeEndObject();
    }

    private void writePrincipals(JsonWriter writer, String fieldName, List<IamPrincipal> principals) {
        if (principals.isEmpty()) {
            return;
        }
        if (principals.size() == 1 && principals.get(0).equals(IamPrincipal.ALL)) {
            this.writeFieldIfNotNull(writer, fieldName, IamPrincipal.ALL.id());
            return;
        }
        principals.forEach(p -> Validate.isTrue((!IamPrincipal.ALL.equals(p) ? 1 : 0) != 0, (String)"IamPrincipal.ALL must not be combined with other principals.", (Object[])new Object[0]));
        LinkedHashMap<IamPrincipalType, List> aggregatedPrincipals = new LinkedHashMap<IamPrincipalType, List>();
        principals.forEach(principal -> aggregatedPrincipals.computeIfAbsent(principal.type(), t -> new ArrayList()).add(principal.id()));
        writer.writeFieldName(fieldName);
        writer.writeStartObject();
        aggregatedPrincipals.forEach((principalType, ids) -> this.writeArrayField(writer, principalType.value(), (List<String>)ids));
        writer.writeEndObject();
    }

    private void writeConditions(JsonWriter writer, List<IamCondition> conditions) {
        if (conditions.isEmpty()) {
            return;
        }
        LinkedHashMap<IamConditionOperator, Map> aggregatedConditions = new LinkedHashMap<IamConditionOperator, Map>();
        conditions.forEach(condition -> aggregatedConditions.computeIfAbsent(condition.operator(), t -> new LinkedHashMap()).computeIfAbsent(condition.key(), t -> new ArrayList()).add(condition.value()));
        writer.writeFieldName("Condition");
        writer.writeStartObject();
        aggregatedConditions.forEach((operator, keyValues) -> {
            writer.writeFieldName(operator.value());
            writer.writeStartObject();
            keyValues.forEach((key, values) -> this.writeArrayField(writer, key.value(), (List<String>)values));
            writer.writeEndObject();
        });
        writer.writeEndObject();
    }

    private void writeValueArrayField(JsonWriter writer, String fieldName, List<? extends IamValue> fieldValues) {
        ArrayList<String> values = new ArrayList<String>(fieldValues.size());
        fieldValues.forEach(v -> values.add(v.value()));
        this.writeArrayField(writer, fieldName, values);
    }

    private void writeArrayField(JsonWriter writer, String fieldName, List<String> fieldValues) {
        if (fieldValues.isEmpty()) {
            return;
        }
        if (fieldValues.size() == 1) {
            this.writeFieldIfNotNull(writer, fieldName, fieldValues.get(0));
            return;
        }
        writer.writeFieldName(fieldName);
        writer.writeStartArray();
        fieldValues.forEach(arg_0 -> ((JsonWriter)writer).writeValue(arg_0));
        writer.writeEndArray();
    }

    private void writeFieldIfNotNull(JsonWriter writer, String key, IamValue value) {
        if (value == null) {
            return;
        }
        this.writeFieldIfNotNull(writer, key, value.value());
    }

    private void writeFieldIfNotNull(JsonWriter writer, String key, String value) {
        if (value != null) {
            writer.writeFieldName(key);
            writer.writeValue(value);
        }
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder
    implements IamPolicyWriter.Builder {
        private Boolean prettyPrint;

        private Builder() {
        }

        private Builder(DefaultIamPolicyWriter writer) {
            this.prettyPrint = writer.prettyPrint;
        }

        @Override
        public IamPolicyWriter.Builder prettyPrint(Boolean prettyPrint) {
            this.prettyPrint = prettyPrint;
            return this;
        }

        public IamPolicyWriter build() {
            return new DefaultIamPolicyWriter(this);
        }
    }
}

