/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AccessDeniedErrorCode {
    ACCESS_DENIED_TO_ASSESSMENT_TARGET("ACCESS_DENIED_TO_ASSESSMENT_TARGET"),
    ACCESS_DENIED_TO_ASSESSMENT_TEMPLATE("ACCESS_DENIED_TO_ASSESSMENT_TEMPLATE"),
    ACCESS_DENIED_TO_ASSESSMENT_RUN("ACCESS_DENIED_TO_ASSESSMENT_RUN"),
    ACCESS_DENIED_TO_FINDING("ACCESS_DENIED_TO_FINDING"),
    ACCESS_DENIED_TO_RESOURCE_GROUP("ACCESS_DENIED_TO_RESOURCE_GROUP"),
    ACCESS_DENIED_TO_RULES_PACKAGE("ACCESS_DENIED_TO_RULES_PACKAGE"),
    ACCESS_DENIED_TO_SNS_TOPIC("ACCESS_DENIED_TO_SNS_TOPIC"),
    ACCESS_DENIED_TO_IAM_ROLE("ACCESS_DENIED_TO_IAM_ROLE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AccessDeniedErrorCode> VALUE_MAP;
    private final String value;

    private AccessDeniedErrorCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AccessDeniedErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AccessDeniedErrorCode> knownValues() {
        EnumSet<AccessDeniedErrorCode> knownValues = EnumSet.allOf(AccessDeniedErrorCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AccessDeniedErrorCode.class, AccessDeniedErrorCode::toString);
    }
}

