/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RelationshipStatus {
    CREATED("CREATED"),
    INVITED("INVITED"),
    DISABLED("DISABLED"),
    ENABLED("ENABLED"),
    REMOVED("REMOVED"),
    RESIGNED("RESIGNED"),
    DELETED("DELETED"),
    EMAIL_VERIFICATION_IN_PROGRESS("EMAIL_VERIFICATION_IN_PROGRESS"),
    EMAIL_VERIFICATION_FAILED("EMAIL_VERIFICATION_FAILED"),
    REGION_DISABLED("REGION_DISABLED"),
    ACCOUNT_SUSPENDED("ACCOUNT_SUSPENDED"),
    CANNOT_CREATE_DETECTOR_IN_ORG_MASTER("CANNOT_CREATE_DETECTOR_IN_ORG_MASTER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RelationshipStatus> VALUE_MAP;
    private final String value;

    private RelationshipStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RelationshipStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RelationshipStatus> knownValues() {
        EnumSet<RelationshipStatus> knownValues = EnumSet.allOf(RelationshipStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RelationshipStatus.class, RelationshipStatus::toString);
    }
}

