/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.ImageTagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsEcrContainerImageDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsEcrContainerImageDetails> {
    private static final SdkField<String> ARCHITECTURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("architecture").getter(AwsEcrContainerImageDetails.getter(AwsEcrContainerImageDetails::architecture)).setter(AwsEcrContainerImageDetails.setter(Builder::architecture)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("architecture").build()}).build();
    private static final SdkField<String> AUTHOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("author").getter(AwsEcrContainerImageDetails.getter(AwsEcrContainerImageDetails::author)).setter(AwsEcrContainerImageDetails.setter(Builder::author)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("author").build()}).build();
    private static final SdkField<String> IMAGE_HASH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageHash").getter(AwsEcrContainerImageDetails.getter(AwsEcrContainerImageDetails::imageHash)).setter(AwsEcrContainerImageDetails.setter(Builder::imageHash)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageHash").build()}).build();
    private static final SdkField<List<String>> IMAGE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("imageTags").getter(AwsEcrContainerImageDetails.getter(AwsEcrContainerImageDetails::imageTags)).setter(AwsEcrContainerImageDetails.setter(Builder::imageTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("platform").getter(AwsEcrContainerImageDetails.getter(AwsEcrContainerImageDetails::platform)).setter(AwsEcrContainerImageDetails.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()}).build();
    private static final SdkField<Instant> PUSHED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("pushedAt").getter(AwsEcrContainerImageDetails.getter(AwsEcrContainerImageDetails::pushedAt)).setter(AwsEcrContainerImageDetails.setter(Builder::pushedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pushedAt").build()}).build();
    private static final SdkField<String> REGISTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("registry").getter(AwsEcrContainerImageDetails.getter(AwsEcrContainerImageDetails::registry)).setter(AwsEcrContainerImageDetails.setter(Builder::registry)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registry").build()}).build();
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryName").getter(AwsEcrContainerImageDetails.getter(AwsEcrContainerImageDetails::repositoryName)).setter(AwsEcrContainerImageDetails.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHITECTURE_FIELD, AUTHOR_FIELD, IMAGE_HASH_FIELD, IMAGE_TAGS_FIELD, PLATFORM_FIELD, PUSHED_AT_FIELD, REGISTRY_FIELD, REPOSITORY_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AwsEcrContainerImageDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String architecture;
    private final String author;
    private final String imageHash;
    private final List<String> imageTags;
    private final String platform;
    private final Instant pushedAt;
    private final String registry;
    private final String repositoryName;

    private AwsEcrContainerImageDetails(BuilderImpl builder) {
        this.architecture = builder.architecture;
        this.author = builder.author;
        this.imageHash = builder.imageHash;
        this.imageTags = builder.imageTags;
        this.platform = builder.platform;
        this.pushedAt = builder.pushedAt;
        this.registry = builder.registry;
        this.repositoryName = builder.repositoryName;
    }

    public final String architecture() {
        return this.architecture;
    }

    public final String author() {
        return this.author;
    }

    public final String imageHash() {
        return this.imageHash;
    }

    public final boolean hasImageTags() {
        return this.imageTags != null && !(this.imageTags instanceof SdkAutoConstructList);
    }

    public final List<String> imageTags() {
        return this.imageTags;
    }

    public final String platform() {
        return this.platform;
    }

    public final Instant pushedAt() {
        return this.pushedAt;
    }

    public final String registry() {
        return this.registry;
    }

    public final String repositoryName() {
        return this.repositoryName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.architecture());
        hashCode = 31 * hashCode + Objects.hashCode(this.author());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageHash());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImageTags() ? this.imageTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.platform());
        hashCode = 31 * hashCode + Objects.hashCode(this.pushedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.registry());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcrContainerImageDetails)) {
            return false;
        }
        AwsEcrContainerImageDetails other = (AwsEcrContainerImageDetails)obj;
        return Objects.equals(this.architecture(), other.architecture()) && Objects.equals(this.author(), other.author()) && Objects.equals(this.imageHash(), other.imageHash()) && this.hasImageTags() == other.hasImageTags() && Objects.equals(this.imageTags(), other.imageTags()) && Objects.equals(this.platform(), other.platform()) && Objects.equals(this.pushedAt(), other.pushedAt()) && Objects.equals(this.registry(), other.registry()) && Objects.equals(this.repositoryName(), other.repositoryName());
    }

    public final String toString() {
        return ToString.builder((String)"AwsEcrContainerImageDetails").add("Architecture", (Object)this.architecture()).add("Author", (Object)this.author()).add("ImageHash", (Object)this.imageHash()).add("ImageTags", this.hasImageTags() ? this.imageTags() : null).add("Platform", (Object)this.platform()).add("PushedAt", (Object)this.pushedAt()).add("Registry", (Object)this.registry()).add("RepositoryName", (Object)this.repositoryName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "architecture": {
                return Optional.ofNullable(clazz.cast(this.architecture()));
            }
            case "author": {
                return Optional.ofNullable(clazz.cast(this.author()));
            }
            case "imageHash": {
                return Optional.ofNullable(clazz.cast(this.imageHash()));
            }
            case "imageTags": {
                return Optional.ofNullable(clazz.cast(this.imageTags()));
            }
            case "platform": {
                return Optional.ofNullable(clazz.cast(this.platform()));
            }
            case "pushedAt": {
                return Optional.ofNullable(clazz.cast(this.pushedAt()));
            }
            case "registry": {
                return Optional.ofNullable(clazz.cast(this.registry()));
            }
            case "repositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("architecture", ARCHITECTURE_FIELD);
        map.put("author", AUTHOR_FIELD);
        map.put("imageHash", IMAGE_HASH_FIELD);
        map.put("imageTags", IMAGE_TAGS_FIELD);
        map.put("platform", PLATFORM_FIELD);
        map.put("pushedAt", PUSHED_AT_FIELD);
        map.put("registry", REGISTRY_FIELD);
        map.put("repositoryName", REPOSITORY_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsEcrContainerImageDetails, T> g) {
        return obj -> g.apply((AwsEcrContainerImageDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String architecture;
        private String author;
        private String imageHash;
        private List<String> imageTags = DefaultSdkAutoConstructList.getInstance();
        private String platform;
        private Instant pushedAt;
        private String registry;
        private String repositoryName;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcrContainerImageDetails model) {
            this.architecture(model.architecture);
            this.author(model.author);
            this.imageHash(model.imageHash);
            this.imageTags(model.imageTags);
            this.platform(model.platform);
            this.pushedAt(model.pushedAt);
            this.registry(model.registry);
            this.repositoryName(model.repositoryName);
        }

        public final String getArchitecture() {
            return this.architecture;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        public final String getAuthor() {
            return this.author;
        }

        public final void setAuthor(String author) {
            this.author = author;
        }

        @Override
        public final Builder author(String author) {
            this.author = author;
            return this;
        }

        public final String getImageHash() {
            return this.imageHash;
        }

        public final void setImageHash(String imageHash) {
            this.imageHash = imageHash;
        }

        @Override
        public final Builder imageHash(String imageHash) {
            this.imageHash = imageHash;
            return this;
        }

        public final Collection<String> getImageTags() {
            if (this.imageTags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.imageTags;
        }

        public final void setImageTags(Collection<String> imageTags) {
            this.imageTags = ImageTagListCopier.copy(imageTags);
        }

        @Override
        public final Builder imageTags(Collection<String> imageTags) {
            this.imageTags = ImageTagListCopier.copy(imageTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageTags(String ... imageTags) {
            this.imageTags(Arrays.asList(imageTags));
            return this;
        }

        public final String getPlatform() {
            return this.platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final Instant getPushedAt() {
            return this.pushedAt;
        }

        public final void setPushedAt(Instant pushedAt) {
            this.pushedAt = pushedAt;
        }

        @Override
        public final Builder pushedAt(Instant pushedAt) {
            this.pushedAt = pushedAt;
            return this;
        }

        public final String getRegistry() {
            return this.registry;
        }

        public final void setRegistry(String registry) {
            this.registry = registry;
        }

        @Override
        public final Builder registry(String registry) {
            this.registry = registry;
            return this;
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public AwsEcrContainerImageDetails build() {
            return new AwsEcrContainerImageDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsEcrContainerImageDetails> {
        public Builder architecture(String var1);

        public Builder author(String var1);

        public Builder imageHash(String var1);

        public Builder imageTags(Collection<String> var1);

        public Builder imageTags(String ... var1);

        public Builder platform(String var1);

        public Builder pushedAt(Instant var1);

        public Builder registry(String var1);

        public Builder repositoryName(String var1);
    }
}

