/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EcrScanFrequency {
    MANUAL("MANUAL"),
    SCAN_ON_PUSH("SCAN_ON_PUSH"),
    CONTINUOUS_SCAN("CONTINUOUS_SCAN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EcrScanFrequency> VALUE_MAP;
    private final String value;

    private EcrScanFrequency(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EcrScanFrequency fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EcrScanFrequency> knownValues() {
        EnumSet<EcrScanFrequency> knownValues = EnumSet.allOf(EcrScanFrequency.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EcrScanFrequency.class, EcrScanFrequency::toString);
    }
}

