/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetectorDebugOption
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DetectorDebugOption> {
    private static final SdkField<String> DETECTOR_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("detectorModelName").getter(DetectorDebugOption.getter(DetectorDebugOption::detectorModelName)).setter(DetectorDebugOption.setter(Builder::detectorModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorModelName").build()}).build();
    private static final SdkField<String> KEY_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("keyValue").getter(DetectorDebugOption.getter(DetectorDebugOption::keyValue)).setter(DetectorDebugOption.setter(Builder::keyValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_MODEL_NAME_FIELD, KEY_VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("detectorModelName", DETECTOR_MODEL_NAME_FIELD);
            this.put("keyValue", KEY_VALUE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String detectorModelName;
    private final String keyValue;

    private DetectorDebugOption(BuilderImpl builder) {
        this.detectorModelName = builder.detectorModelName;
        this.keyValue = builder.keyValue;
    }

    public final String detectorModelName() {
        return this.detectorModelName;
    }

    public final String keyValue() {
        return this.keyValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorModelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectorDebugOption)) {
            return false;
        }
        DetectorDebugOption other = (DetectorDebugOption)obj;
        return Objects.equals(this.detectorModelName(), other.detectorModelName()) && Objects.equals(this.keyValue(), other.keyValue());
    }

    public final String toString() {
        return ToString.builder((String)"DetectorDebugOption").add("DetectorModelName", (Object)this.detectorModelName()).add("KeyValue", (Object)this.keyValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "detectorModelName": {
                return Optional.ofNullable(clazz.cast(this.detectorModelName()));
            }
            case "keyValue": {
                return Optional.ofNullable(clazz.cast(this.keyValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DetectorDebugOption, T> g) {
        return obj -> g.apply((DetectorDebugOption)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String detectorModelName;
        private String keyValue;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectorDebugOption model) {
            this.detectorModelName(model.detectorModelName);
            this.keyValue(model.keyValue);
        }

        public final String getDetectorModelName() {
            return this.detectorModelName;
        }

        public final void setDetectorModelName(String detectorModelName) {
            this.detectorModelName = detectorModelName;
        }

        @Override
        public final Builder detectorModelName(String detectorModelName) {
            this.detectorModelName = detectorModelName;
            return this;
        }

        public final String getKeyValue() {
            return this.keyValue;
        }

        public final void setKeyValue(String keyValue) {
            this.keyValue = keyValue;
        }

        @Override
        public final Builder keyValue(String keyValue) {
            this.keyValue = keyValue;
            return this;
        }

        public DetectorDebugOption build() {
            return new DetectorDebugOption(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DetectorDebugOption> {
        public Builder detectorModelName(String var1);

        public Builder keyValue(String var1);
    }
}

