/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotevents.model.RecipientDetail;
import software.amazon.awssdk.services.iotevents.model.RecipientDetailsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SMSConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SMSConfiguration> {
    private static final SdkField<String> SENDER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("senderId").getter(SMSConfiguration.getter(SMSConfiguration::senderId)).setter(SMSConfiguration.setter(Builder::senderId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("senderId").build()}).build();
    private static final SdkField<String> ADDITIONAL_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("additionalMessage").getter(SMSConfiguration.getter(SMSConfiguration::additionalMessage)).setter(SMSConfiguration.setter(Builder::additionalMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalMessage").build()}).build();
    private static final SdkField<List<RecipientDetail>> RECIPIENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("recipients").getter(SMSConfiguration.getter(SMSConfiguration::recipients)).setter(SMSConfiguration.setter(Builder::recipients)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recipients").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecipientDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SENDER_ID_FIELD, ADDITIONAL_MESSAGE_FIELD, RECIPIENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("senderId", SENDER_ID_FIELD);
            this.put("additionalMessage", ADDITIONAL_MESSAGE_FIELD);
            this.put("recipients", RECIPIENTS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String senderId;
    private final String additionalMessage;
    private final List<RecipientDetail> recipients;

    private SMSConfiguration(BuilderImpl builder) {
        this.senderId = builder.senderId;
        this.additionalMessage = builder.additionalMessage;
        this.recipients = builder.recipients;
    }

    public final String senderId() {
        return this.senderId;
    }

    public final String additionalMessage() {
        return this.additionalMessage;
    }

    public final boolean hasRecipients() {
        return this.recipients != null && !(this.recipients instanceof SdkAutoConstructList);
    }

    public final List<RecipientDetail> recipients() {
        return this.recipients;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.senderId());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecipients() ? this.recipients() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SMSConfiguration)) {
            return false;
        }
        SMSConfiguration other = (SMSConfiguration)obj;
        return Objects.equals(this.senderId(), other.senderId()) && Objects.equals(this.additionalMessage(), other.additionalMessage()) && this.hasRecipients() == other.hasRecipients() && Objects.equals(this.recipients(), other.recipients());
    }

    public final String toString() {
        return ToString.builder((String)"SMSConfiguration").add("SenderId", (Object)this.senderId()).add("AdditionalMessage", (Object)this.additionalMessage()).add("Recipients", this.hasRecipients() ? this.recipients() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "senderId": {
                return Optional.ofNullable(clazz.cast(this.senderId()));
            }
            case "additionalMessage": {
                return Optional.ofNullable(clazz.cast(this.additionalMessage()));
            }
            case "recipients": {
                return Optional.ofNullable(clazz.cast(this.recipients()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SMSConfiguration, T> g) {
        return obj -> g.apply((SMSConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String senderId;
        private String additionalMessage;
        private List<RecipientDetail> recipients = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SMSConfiguration model) {
            this.senderId(model.senderId);
            this.additionalMessage(model.additionalMessage);
            this.recipients(model.recipients);
        }

        public final String getSenderId() {
            return this.senderId;
        }

        public final void setSenderId(String senderId) {
            this.senderId = senderId;
        }

        @Override
        public final Builder senderId(String senderId) {
            this.senderId = senderId;
            return this;
        }

        public final String getAdditionalMessage() {
            return this.additionalMessage;
        }

        public final void setAdditionalMessage(String additionalMessage) {
            this.additionalMessage = additionalMessage;
        }

        @Override
        public final Builder additionalMessage(String additionalMessage) {
            this.additionalMessage = additionalMessage;
            return this;
        }

        public final List<RecipientDetail.Builder> getRecipients() {
            List<RecipientDetail.Builder> result = RecipientDetailsCopier.copyToBuilder(this.recipients);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecipients(Collection<RecipientDetail.BuilderImpl> recipients) {
            this.recipients = RecipientDetailsCopier.copyFromBuilder(recipients);
        }

        @Override
        public final Builder recipients(Collection<RecipientDetail> recipients) {
            this.recipients = RecipientDetailsCopier.copy(recipients);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recipients(RecipientDetail ... recipients) {
            this.recipients(Arrays.asList(recipients));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recipients(Consumer<RecipientDetail.Builder> ... recipients) {
            this.recipients(Stream.of(recipients).map(c -> (RecipientDetail)((RecipientDetail.Builder)RecipientDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public SMSConfiguration build() {
            return new SMSConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SMSConfiguration> {
        public Builder senderId(String var1);

        public Builder additionalMessage(String var1);

        public Builder recipients(Collection<RecipientDetail> var1);

        public Builder recipients(RecipientDetail ... var1);

        public Builder recipients(Consumer<RecipientDetail.Builder> ... var1);
    }
}

