/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotthingsgraph.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotthingsgraph.IoTThingsGraphClient;
import software.amazon.awssdk.services.iotthingsgraph.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemInstancesRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemInstancesResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.SystemInstanceSummary;

public class SearchSystemInstancesIterable
implements SdkIterable<SearchSystemInstancesResponse> {
    private final IoTThingsGraphClient client;
    private final SearchSystemInstancesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchSystemInstancesIterable(IoTThingsGraphClient client, SearchSystemInstancesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SearchSystemInstancesResponseFetcher();
    }

    public Iterator<SearchSystemInstancesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SystemInstanceSummary> summaries() {
        Function<SearchSystemInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.summaries() != null) {
                return response.summaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchSystemInstancesResponseFetcher
    implements SyncPageFetcher<SearchSystemInstancesResponse> {
        private SearchSystemInstancesResponseFetcher() {
        }

        public boolean hasNextPage(SearchSystemInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchSystemInstancesResponse nextPage(SearchSystemInstancesResponse previousPage) {
            if (previousPage == null) {
                return SearchSystemInstancesIterable.this.client.searchSystemInstances(SearchSystemInstancesIterable.this.firstRequest);
            }
            return SearchSystemInstancesIterable.this.client.searchSystemInstances((SearchSystemInstancesRequest)((Object)SearchSystemInstancesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

