/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.HierarchicalPrincipal;
import software.amazon.awssdk.services.kendra.model.HierarchicalPrincipalListCopier;
import software.amazon.awssdk.services.kendra.model.KendraRequest;
import software.amazon.awssdk.services.kendra.model.Principal;
import software.amazon.awssdk.services.kendra.model.PrincipalListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAccessControlConfigurationRequest
extends KendraRequest
implements ToCopyableBuilder<Builder, UpdateAccessControlConfigurationRequest> {
    private static final SdkField<String> INDEX_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexId").getter(UpdateAccessControlConfigurationRequest.getter(UpdateAccessControlConfigurationRequest::indexId)).setter(UpdateAccessControlConfigurationRequest.setter(Builder::indexId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(UpdateAccessControlConfigurationRequest.getter(UpdateAccessControlConfigurationRequest::id)).setter(UpdateAccessControlConfigurationRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateAccessControlConfigurationRequest.getter(UpdateAccessControlConfigurationRequest::name)).setter(UpdateAccessControlConfigurationRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateAccessControlConfigurationRequest.getter(UpdateAccessControlConfigurationRequest::description)).setter(UpdateAccessControlConfigurationRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<Principal>> ACCESS_CONTROL_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AccessControlList").getter(UpdateAccessControlConfigurationRequest.getter(UpdateAccessControlConfigurationRequest::accessControlList)).setter(UpdateAccessControlConfigurationRequest.setter(Builder::accessControlList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessControlList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Principal::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<HierarchicalPrincipal>> HIERARCHICAL_ACCESS_CONTROL_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HierarchicalAccessControlList").getter(UpdateAccessControlConfigurationRequest.getter(UpdateAccessControlConfigurationRequest::hierarchicalAccessControlList)).setter(UpdateAccessControlConfigurationRequest.setter(Builder::hierarchicalAccessControlList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HierarchicalAccessControlList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HierarchicalPrincipal::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_ID_FIELD, ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, ACCESS_CONTROL_LIST_FIELD, HIERARCHICAL_ACCESS_CONTROL_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateAccessControlConfigurationRequest.memberNameToFieldInitializer();
    private final String indexId;
    private final String id;
    private final String name;
    private final String description;
    private final List<Principal> accessControlList;
    private final List<HierarchicalPrincipal> hierarchicalAccessControlList;

    private UpdateAccessControlConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.indexId = builder.indexId;
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.accessControlList = builder.accessControlList;
        this.hierarchicalAccessControlList = builder.hierarchicalAccessControlList;
    }

    public final String indexId() {
        return this.indexId;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasAccessControlList() {
        return this.accessControlList != null && !(this.accessControlList instanceof SdkAutoConstructList);
    }

    public final List<Principal> accessControlList() {
        return this.accessControlList;
    }

    public final boolean hasHierarchicalAccessControlList() {
        return this.hierarchicalAccessControlList != null && !(this.hierarchicalAccessControlList instanceof SdkAutoConstructList);
    }

    public final List<HierarchicalPrincipal> hierarchicalAccessControlList() {
        return this.hierarchicalAccessControlList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.indexId());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccessControlList() ? this.accessControlList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHierarchicalAccessControlList() ? this.hierarchicalAccessControlList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAccessControlConfigurationRequest)) {
            return false;
        }
        UpdateAccessControlConfigurationRequest other = (UpdateAccessControlConfigurationRequest)((Object)obj);
        return Objects.equals(this.indexId(), other.indexId()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasAccessControlList() == other.hasAccessControlList() && Objects.equals(this.accessControlList(), other.accessControlList()) && this.hasHierarchicalAccessControlList() == other.hasHierarchicalAccessControlList() && Objects.equals(this.hierarchicalAccessControlList(), other.hierarchicalAccessControlList());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAccessControlConfigurationRequest").add("IndexId", (Object)this.indexId()).add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("AccessControlList", this.hasAccessControlList() ? this.accessControlList() : null).add("HierarchicalAccessControlList", this.hasHierarchicalAccessControlList() ? this.hierarchicalAccessControlList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IndexId": {
                return Optional.ofNullable(clazz.cast(this.indexId()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "AccessControlList": {
                return Optional.ofNullable(clazz.cast(this.accessControlList()));
            }
            case "HierarchicalAccessControlList": {
                return Optional.ofNullable(clazz.cast(this.hierarchicalAccessControlList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("IndexId", INDEX_ID_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("AccessControlList", ACCESS_CONTROL_LIST_FIELD);
        map.put("HierarchicalAccessControlList", HIERARCHICAL_ACCESS_CONTROL_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAccessControlConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateAccessControlConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KendraRequest.BuilderImpl
    implements Builder {
        private String indexId;
        private String id;
        private String name;
        private String description;
        private List<Principal> accessControlList = DefaultSdkAutoConstructList.getInstance();
        private List<HierarchicalPrincipal> hierarchicalAccessControlList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAccessControlConfigurationRequest model) {
            super(model);
            this.indexId(model.indexId);
            this.id(model.id);
            this.name(model.name);
            this.description(model.description);
            this.accessControlList(model.accessControlList);
            this.hierarchicalAccessControlList(model.hierarchicalAccessControlList);
        }

        public final String getIndexId() {
            return this.indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Principal.Builder> getAccessControlList() {
            List<Principal.Builder> result = PrincipalListCopier.copyToBuilder(this.accessControlList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccessControlList(Collection<Principal.BuilderImpl> accessControlList) {
            this.accessControlList = PrincipalListCopier.copyFromBuilder(accessControlList);
        }

        @Override
        public final Builder accessControlList(Collection<Principal> accessControlList) {
            this.accessControlList = PrincipalListCopier.copy(accessControlList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessControlList(Principal ... accessControlList) {
            this.accessControlList(Arrays.asList(accessControlList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessControlList(Consumer<Principal.Builder> ... accessControlList) {
            this.accessControlList(Stream.of(accessControlList).map(c -> (Principal)((Principal.Builder)Principal.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<HierarchicalPrincipal.Builder> getHierarchicalAccessControlList() {
            List<HierarchicalPrincipal.Builder> result = HierarchicalPrincipalListCopier.copyToBuilder(this.hierarchicalAccessControlList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHierarchicalAccessControlList(Collection<HierarchicalPrincipal.BuilderImpl> hierarchicalAccessControlList) {
            this.hierarchicalAccessControlList = HierarchicalPrincipalListCopier.copyFromBuilder(hierarchicalAccessControlList);
        }

        @Override
        public final Builder hierarchicalAccessControlList(Collection<HierarchicalPrincipal> hierarchicalAccessControlList) {
            this.hierarchicalAccessControlList = HierarchicalPrincipalListCopier.copy(hierarchicalAccessControlList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hierarchicalAccessControlList(HierarchicalPrincipal ... hierarchicalAccessControlList) {
            this.hierarchicalAccessControlList(Arrays.asList(hierarchicalAccessControlList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hierarchicalAccessControlList(Consumer<HierarchicalPrincipal.Builder> ... hierarchicalAccessControlList) {
            this.hierarchicalAccessControlList(Stream.of(hierarchicalAccessControlList).map(c -> (HierarchicalPrincipal)((HierarchicalPrincipal.Builder)HierarchicalPrincipal.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAccessControlConfigurationRequest build() {
            return new UpdateAccessControlConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KendraRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAccessControlConfigurationRequest> {
        public Builder indexId(String var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder accessControlList(Collection<Principal> var1);

        public Builder accessControlList(Principal ... var1);

        public Builder accessControlList(Consumer<Principal.Builder> ... var1);

        public Builder hierarchicalAccessControlList(Collection<HierarchicalPrincipal> var1);

        public Builder hierarchicalAccessControlList(HierarchicalPrincipal ... var1);

        public Builder hierarchicalAccessControlList(Consumer<HierarchicalPrincipal.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

