/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2AsyncClient;
import software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListTestSetsResponse;

public class ListTestSetsPublisher
implements SdkPublisher<ListTestSetsResponse> {
    private final LexModelsV2AsyncClient client;
    private final ListTestSetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTestSetsPublisher(LexModelsV2AsyncClient client, ListTestSetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTestSetsPublisher(LexModelsV2AsyncClient client, ListTestSetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTestSetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTestSetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListTestSetsResponseFetcher
    implements AsyncPageFetcher<ListTestSetsResponse> {
        private ListTestSetsResponseFetcher() {
        }

        public boolean hasNextPage(ListTestSetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTestSetsResponse> nextPage(ListTestSetsResponse previousPage) {
            if (previousPage == null) {
                return ListTestSetsPublisher.this.client.listTestSets(ListTestSetsPublisher.this.firstRequest);
            }
            return ListTestSetsPublisher.this.client.listTestSets((ListTestSetsRequest)((Object)ListTestSetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

