/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.LightsailResponse;
import software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificate;
import software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetLoadBalancerTlsCertificatesResponse
extends LightsailResponse
implements ToCopyableBuilder<Builder, GetLoadBalancerTlsCertificatesResponse> {
    private static final SdkField<List<LoadBalancerTlsCertificate>> TLS_CERTIFICATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tlsCertificates").getter(GetLoadBalancerTlsCertificatesResponse.getter(GetLoadBalancerTlsCertificatesResponse::tlsCertificates)).setter(GetLoadBalancerTlsCertificatesResponse.setter(Builder::tlsCertificates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tlsCertificates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LoadBalancerTlsCertificate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TLS_CERTIFICATES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetLoadBalancerTlsCertificatesResponse.memberNameToFieldInitializer();
    private final List<LoadBalancerTlsCertificate> tlsCertificates;

    private GetLoadBalancerTlsCertificatesResponse(BuilderImpl builder) {
        super(builder);
        this.tlsCertificates = builder.tlsCertificates;
    }

    public final boolean hasTlsCertificates() {
        return this.tlsCertificates != null && !(this.tlsCertificates instanceof SdkAutoConstructList);
    }

    public final List<LoadBalancerTlsCertificate> tlsCertificates() {
        return this.tlsCertificates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTlsCertificates() ? this.tlsCertificates() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLoadBalancerTlsCertificatesResponse)) {
            return false;
        }
        GetLoadBalancerTlsCertificatesResponse other = (GetLoadBalancerTlsCertificatesResponse)((Object)obj);
        return this.hasTlsCertificates() == other.hasTlsCertificates() && Objects.equals(this.tlsCertificates(), other.tlsCertificates());
    }

    public final String toString() {
        return ToString.builder((String)"GetLoadBalancerTlsCertificatesResponse").add("TlsCertificates", this.hasTlsCertificates() ? this.tlsCertificates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tlsCertificates": {
                return Optional.ofNullable(clazz.cast(this.tlsCertificates()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<LoadBalancerTlsCertificate>>> map = new HashMap<String, SdkField<List<LoadBalancerTlsCertificate>>>();
        map.put("tlsCertificates", TLS_CERTIFICATES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetLoadBalancerTlsCertificatesResponse, T> g) {
        return obj -> g.apply((GetLoadBalancerTlsCertificatesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailResponse.BuilderImpl
    implements Builder {
        private List<LoadBalancerTlsCertificate> tlsCertificates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetLoadBalancerTlsCertificatesResponse model) {
            super(model);
            this.tlsCertificates(model.tlsCertificates);
        }

        public final List<LoadBalancerTlsCertificate.Builder> getTlsCertificates() {
            List<LoadBalancerTlsCertificate.Builder> result = LoadBalancerTlsCertificateListCopier.copyToBuilder(this.tlsCertificates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTlsCertificates(Collection<LoadBalancerTlsCertificate.BuilderImpl> tlsCertificates) {
            this.tlsCertificates = LoadBalancerTlsCertificateListCopier.copyFromBuilder(tlsCertificates);
        }

        @Override
        public final Builder tlsCertificates(Collection<LoadBalancerTlsCertificate> tlsCertificates) {
            this.tlsCertificates = LoadBalancerTlsCertificateListCopier.copy(tlsCertificates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tlsCertificates(LoadBalancerTlsCertificate ... tlsCertificates) {
            this.tlsCertificates(Arrays.asList(tlsCertificates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tlsCertificates(Consumer<LoadBalancerTlsCertificate.Builder> ... tlsCertificates) {
            this.tlsCertificates(Stream.of(tlsCertificates).map(c -> (LoadBalancerTlsCertificate)((LoadBalancerTlsCertificate.Builder)LoadBalancerTlsCertificate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetLoadBalancerTlsCertificatesResponse build() {
            return new GetLoadBalancerTlsCertificatesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LightsailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetLoadBalancerTlsCertificatesResponse> {
        public Builder tlsCertificates(Collection<LoadBalancerTlsCertificate> var1);

        public Builder tlsCertificates(LoadBalancerTlsCertificate ... var1);

        public Builder tlsCertificates(Consumer<LoadBalancerTlsCertificate.Builder> ... var1);
    }
}

