/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lookoutequipment.LookoutEquipmentClient;
import software.amazon.awssdk.services.lookoutequipment.internal.UserAgentUtils;
import software.amazon.awssdk.services.lookoutequipment.model.ListModelVersionsRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ListModelVersionsResponse;

public class ListModelVersionsIterable
implements SdkIterable<ListModelVersionsResponse> {
    private final LookoutEquipmentClient client;
    private final ListModelVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListModelVersionsIterable(LookoutEquipmentClient client, ListModelVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListModelVersionsResponseFetcher();
    }

    public Iterator<ListModelVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListModelVersionsResponseFetcher
    implements SyncPageFetcher<ListModelVersionsResponse> {
        private ListModelVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListModelVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListModelVersionsResponse nextPage(ListModelVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListModelVersionsIterable.this.client.listModelVersions(ListModelVersionsIterable.this.firstRequest);
            }
            return ListModelVersionsIterable.this.client.listModelVersions((ListModelVersionsRequest)((Object)ListModelVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

