/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutequipment.model.DataQualitySummary;
import software.amazon.awssdk.services.lookoutequipment.model.IngestedFilesSummary;
import software.amazon.awssdk.services.lookoutequipment.model.IngestionInputConfiguration;
import software.amazon.awssdk.services.lookoutequipment.model.IngestionJobStatus;
import software.amazon.awssdk.services.lookoutequipment.model.LookoutEquipmentResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDataIngestionJobResponse
extends LookoutEquipmentResponse
implements ToCopyableBuilder<Builder, DescribeDataIngestionJobResponse> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobId").getter(DescribeDataIngestionJobResponse.getter(DescribeDataIngestionJobResponse::jobId)).setter(DescribeDataIngestionJobResponse.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()}).build();
    private static final SdkField<String> DATASET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetArn").getter(DescribeDataIngestionJobResponse.getter(DescribeDataIngestionJobResponse::datasetArn)).setter(DescribeDataIngestionJobResponse.setter(Builder::datasetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetArn").build()}).build();
    private static final SdkField<IngestionInputConfiguration> INGESTION_INPUT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IngestionInputConfiguration").getter(DescribeDataIngestionJobResponse.getter(DescribeDataIngestionJobResponse::ingestionInputConfiguration)).setter(DescribeDataIngestionJobResponse.setter(Builder::ingestionInputConfiguration)).constructor(IngestionInputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngestionInputConfiguration").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(DescribeDataIngestionJobResponse.getter(DescribeDataIngestionJobResponse::roleArn)).setter(DescribeDataIngestionJobResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(DescribeDataIngestionJobResponse.getter(DescribeDataIngestionJobResponse::createdAt)).setter(DescribeDataIngestionJobResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeDataIngestionJobResponse.getter(DescribeDataIngestionJobResponse::statusAsString)).setter(DescribeDataIngestionJobResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> FAILED_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailedReason").getter(DescribeDataIngestionJobResponse.getter(DescribeDataIngestionJobResponse::failedReason)).setter(DescribeDataIngestionJobResponse.setter(Builder::failedReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedReason").build()}).build();
    private static final SdkField<DataQualitySummary> DATA_QUALITY_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataQualitySummary").getter(DescribeDataIngestionJobResponse.getter(DescribeDataIngestionJobResponse::dataQualitySummary)).setter(DescribeDataIngestionJobResponse.setter(Builder::dataQualitySummary)).constructor(DataQualitySummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataQualitySummary").build()}).build();
    private static final SdkField<IngestedFilesSummary> INGESTED_FILES_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IngestedFilesSummary").getter(DescribeDataIngestionJobResponse.getter(DescribeDataIngestionJobResponse::ingestedFilesSummary)).setter(DescribeDataIngestionJobResponse.setter(Builder::ingestedFilesSummary)).constructor(IngestedFilesSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngestedFilesSummary").build()}).build();
    private static final SdkField<String> STATUS_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusDetail").getter(DescribeDataIngestionJobResponse.getter(DescribeDataIngestionJobResponse::statusDetail)).setter(DescribeDataIngestionJobResponse.setter(Builder::statusDetail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusDetail").build()}).build();
    private static final SdkField<Long> INGESTED_DATA_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("IngestedDataSize").getter(DescribeDataIngestionJobResponse.getter(DescribeDataIngestionJobResponse::ingestedDataSize)).setter(DescribeDataIngestionJobResponse.setter(Builder::ingestedDataSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngestedDataSize").build()}).build();
    private static final SdkField<Instant> DATA_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DataStartTime").getter(DescribeDataIngestionJobResponse.getter(DescribeDataIngestionJobResponse::dataStartTime)).setter(DescribeDataIngestionJobResponse.setter(Builder::dataStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataStartTime").build()}).build();
    private static final SdkField<Instant> DATA_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DataEndTime").getter(DescribeDataIngestionJobResponse.getter(DescribeDataIngestionJobResponse::dataEndTime)).setter(DescribeDataIngestionJobResponse.setter(Builder::dataEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataEndTime").build()}).build();
    private static final SdkField<String> SOURCE_DATASET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceDatasetArn").getter(DescribeDataIngestionJobResponse.getter(DescribeDataIngestionJobResponse::sourceDatasetArn)).setter(DescribeDataIngestionJobResponse.setter(Builder::sourceDatasetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDatasetArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, DATASET_ARN_FIELD, INGESTION_INPUT_CONFIGURATION_FIELD, ROLE_ARN_FIELD, CREATED_AT_FIELD, STATUS_FIELD, FAILED_REASON_FIELD, DATA_QUALITY_SUMMARY_FIELD, INGESTED_FILES_SUMMARY_FIELD, STATUS_DETAIL_FIELD, INGESTED_DATA_SIZE_FIELD, DATA_START_TIME_FIELD, DATA_END_TIME_FIELD, SOURCE_DATASET_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeDataIngestionJobResponse.memberNameToFieldInitializer();
    private final String jobId;
    private final String datasetArn;
    private final IngestionInputConfiguration ingestionInputConfiguration;
    private final String roleArn;
    private final Instant createdAt;
    private final String status;
    private final String failedReason;
    private final DataQualitySummary dataQualitySummary;
    private final IngestedFilesSummary ingestedFilesSummary;
    private final String statusDetail;
    private final Long ingestedDataSize;
    private final Instant dataStartTime;
    private final Instant dataEndTime;
    private final String sourceDatasetArn;

    private DescribeDataIngestionJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.datasetArn = builder.datasetArn;
        this.ingestionInputConfiguration = builder.ingestionInputConfiguration;
        this.roleArn = builder.roleArn;
        this.createdAt = builder.createdAt;
        this.status = builder.status;
        this.failedReason = builder.failedReason;
        this.dataQualitySummary = builder.dataQualitySummary;
        this.ingestedFilesSummary = builder.ingestedFilesSummary;
        this.statusDetail = builder.statusDetail;
        this.ingestedDataSize = builder.ingestedDataSize;
        this.dataStartTime = builder.dataStartTime;
        this.dataEndTime = builder.dataEndTime;
        this.sourceDatasetArn = builder.sourceDatasetArn;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final String datasetArn() {
        return this.datasetArn;
    }

    public final IngestionInputConfiguration ingestionInputConfiguration() {
        return this.ingestionInputConfiguration;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final IngestionJobStatus status() {
        return IngestionJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String failedReason() {
        return this.failedReason;
    }

    public final DataQualitySummary dataQualitySummary() {
        return this.dataQualitySummary;
    }

    public final IngestedFilesSummary ingestedFilesSummary() {
        return this.ingestedFilesSummary;
    }

    public final String statusDetail() {
        return this.statusDetail;
    }

    public final Long ingestedDataSize() {
        return this.ingestedDataSize;
    }

    public final Instant dataStartTime() {
        return this.dataStartTime;
    }

    public final Instant dataEndTime() {
        return this.dataEndTime;
    }

    public final String sourceDatasetArn() {
        return this.sourceDatasetArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestionInputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failedReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataQualitySummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestedFilesSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusDetail());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestedDataSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDatasetArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDataIngestionJobResponse)) {
            return false;
        }
        DescribeDataIngestionJobResponse other = (DescribeDataIngestionJobResponse)((Object)obj);
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.datasetArn(), other.datasetArn()) && Objects.equals(this.ingestionInputConfiguration(), other.ingestionInputConfiguration()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.failedReason(), other.failedReason()) && Objects.equals(this.dataQualitySummary(), other.dataQualitySummary()) && Objects.equals(this.ingestedFilesSummary(), other.ingestedFilesSummary()) && Objects.equals(this.statusDetail(), other.statusDetail()) && Objects.equals(this.ingestedDataSize(), other.ingestedDataSize()) && Objects.equals(this.dataStartTime(), other.dataStartTime()) && Objects.equals(this.dataEndTime(), other.dataEndTime()) && Objects.equals(this.sourceDatasetArn(), other.sourceDatasetArn());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDataIngestionJobResponse").add("JobId", (Object)this.jobId()).add("DatasetArn", (Object)this.datasetArn()).add("IngestionInputConfiguration", (Object)this.ingestionInputConfiguration()).add("RoleArn", (Object)this.roleArn()).add("CreatedAt", (Object)this.createdAt()).add("Status", (Object)this.statusAsString()).add("FailedReason", (Object)this.failedReason()).add("DataQualitySummary", (Object)this.dataQualitySummary()).add("IngestedFilesSummary", (Object)this.ingestedFilesSummary()).add("StatusDetail", (Object)this.statusDetail()).add("IngestedDataSize", (Object)this.ingestedDataSize()).add("DataStartTime", (Object)this.dataStartTime()).add("DataEndTime", (Object)this.dataEndTime()).add("SourceDatasetArn", (Object)this.sourceDatasetArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "DatasetArn": {
                return Optional.ofNullable(clazz.cast(this.datasetArn()));
            }
            case "IngestionInputConfiguration": {
                return Optional.ofNullable(clazz.cast(this.ingestionInputConfiguration()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "FailedReason": {
                return Optional.ofNullable(clazz.cast(this.failedReason()));
            }
            case "DataQualitySummary": {
                return Optional.ofNullable(clazz.cast(this.dataQualitySummary()));
            }
            case "IngestedFilesSummary": {
                return Optional.ofNullable(clazz.cast(this.ingestedFilesSummary()));
            }
            case "StatusDetail": {
                return Optional.ofNullable(clazz.cast(this.statusDetail()));
            }
            case "IngestedDataSize": {
                return Optional.ofNullable(clazz.cast(this.ingestedDataSize()));
            }
            case "DataStartTime": {
                return Optional.ofNullable(clazz.cast(this.dataStartTime()));
            }
            case "DataEndTime": {
                return Optional.ofNullable(clazz.cast(this.dataEndTime()));
            }
            case "SourceDatasetArn": {
                return Optional.ofNullable(clazz.cast(this.sourceDatasetArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("JobId", JOB_ID_FIELD);
        map.put("DatasetArn", DATASET_ARN_FIELD);
        map.put("IngestionInputConfiguration", INGESTION_INPUT_CONFIGURATION_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("FailedReason", FAILED_REASON_FIELD);
        map.put("DataQualitySummary", DATA_QUALITY_SUMMARY_FIELD);
        map.put("IngestedFilesSummary", INGESTED_FILES_SUMMARY_FIELD);
        map.put("StatusDetail", STATUS_DETAIL_FIELD);
        map.put("IngestedDataSize", INGESTED_DATA_SIZE_FIELD);
        map.put("DataStartTime", DATA_START_TIME_FIELD);
        map.put("DataEndTime", DATA_END_TIME_FIELD);
        map.put("SourceDatasetArn", SOURCE_DATASET_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDataIngestionJobResponse, T> g) {
        return obj -> g.apply((DescribeDataIngestionJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutEquipmentResponse.BuilderImpl
    implements Builder {
        private String jobId;
        private String datasetArn;
        private IngestionInputConfiguration ingestionInputConfiguration;
        private String roleArn;
        private Instant createdAt;
        private String status;
        private String failedReason;
        private DataQualitySummary dataQualitySummary;
        private IngestedFilesSummary ingestedFilesSummary;
        private String statusDetail;
        private Long ingestedDataSize;
        private Instant dataStartTime;
        private Instant dataEndTime;
        private String sourceDatasetArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDataIngestionJobResponse model) {
            super(model);
            this.jobId(model.jobId);
            this.datasetArn(model.datasetArn);
            this.ingestionInputConfiguration(model.ingestionInputConfiguration);
            this.roleArn(model.roleArn);
            this.createdAt(model.createdAt);
            this.status(model.status);
            this.failedReason(model.failedReason);
            this.dataQualitySummary(model.dataQualitySummary);
            this.ingestedFilesSummary(model.ingestedFilesSummary);
            this.statusDetail(model.statusDetail);
            this.ingestedDataSize(model.ingestedDataSize);
            this.dataStartTime(model.dataStartTime);
            this.dataEndTime(model.dataEndTime);
            this.sourceDatasetArn(model.sourceDatasetArn);
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getDatasetArn() {
            return this.datasetArn;
        }

        public final void setDatasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
        }

        @Override
        public final Builder datasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
            return this;
        }

        public final IngestionInputConfiguration.Builder getIngestionInputConfiguration() {
            return this.ingestionInputConfiguration != null ? this.ingestionInputConfiguration.toBuilder() : null;
        }

        public final void setIngestionInputConfiguration(IngestionInputConfiguration.BuilderImpl ingestionInputConfiguration) {
            this.ingestionInputConfiguration = ingestionInputConfiguration != null ? ingestionInputConfiguration.build() : null;
        }

        @Override
        public final Builder ingestionInputConfiguration(IngestionInputConfiguration ingestionInputConfiguration) {
            this.ingestionInputConfiguration = ingestionInputConfiguration;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(IngestionJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFailedReason() {
            return this.failedReason;
        }

        public final void setFailedReason(String failedReason) {
            this.failedReason = failedReason;
        }

        @Override
        public final Builder failedReason(String failedReason) {
            this.failedReason = failedReason;
            return this;
        }

        public final DataQualitySummary.Builder getDataQualitySummary() {
            return this.dataQualitySummary != null ? this.dataQualitySummary.toBuilder() : null;
        }

        public final void setDataQualitySummary(DataQualitySummary.BuilderImpl dataQualitySummary) {
            this.dataQualitySummary = dataQualitySummary != null ? dataQualitySummary.build() : null;
        }

        @Override
        public final Builder dataQualitySummary(DataQualitySummary dataQualitySummary) {
            this.dataQualitySummary = dataQualitySummary;
            return this;
        }

        public final IngestedFilesSummary.Builder getIngestedFilesSummary() {
            return this.ingestedFilesSummary != null ? this.ingestedFilesSummary.toBuilder() : null;
        }

        public final void setIngestedFilesSummary(IngestedFilesSummary.BuilderImpl ingestedFilesSummary) {
            this.ingestedFilesSummary = ingestedFilesSummary != null ? ingestedFilesSummary.build() : null;
        }

        @Override
        public final Builder ingestedFilesSummary(IngestedFilesSummary ingestedFilesSummary) {
            this.ingestedFilesSummary = ingestedFilesSummary;
            return this;
        }

        public final String getStatusDetail() {
            return this.statusDetail;
        }

        public final void setStatusDetail(String statusDetail) {
            this.statusDetail = statusDetail;
        }

        @Override
        public final Builder statusDetail(String statusDetail) {
            this.statusDetail = statusDetail;
            return this;
        }

        public final Long getIngestedDataSize() {
            return this.ingestedDataSize;
        }

        public final void setIngestedDataSize(Long ingestedDataSize) {
            this.ingestedDataSize = ingestedDataSize;
        }

        @Override
        public final Builder ingestedDataSize(Long ingestedDataSize) {
            this.ingestedDataSize = ingestedDataSize;
            return this;
        }

        public final Instant getDataStartTime() {
            return this.dataStartTime;
        }

        public final void setDataStartTime(Instant dataStartTime) {
            this.dataStartTime = dataStartTime;
        }

        @Override
        public final Builder dataStartTime(Instant dataStartTime) {
            this.dataStartTime = dataStartTime;
            return this;
        }

        public final Instant getDataEndTime() {
            return this.dataEndTime;
        }

        public final void setDataEndTime(Instant dataEndTime) {
            this.dataEndTime = dataEndTime;
        }

        @Override
        public final Builder dataEndTime(Instant dataEndTime) {
            this.dataEndTime = dataEndTime;
            return this;
        }

        public final String getSourceDatasetArn() {
            return this.sourceDatasetArn;
        }

        public final void setSourceDatasetArn(String sourceDatasetArn) {
            this.sourceDatasetArn = sourceDatasetArn;
        }

        @Override
        public final Builder sourceDatasetArn(String sourceDatasetArn) {
            this.sourceDatasetArn = sourceDatasetArn;
            return this;
        }

        @Override
        public DescribeDataIngestionJobResponse build() {
            return new DescribeDataIngestionJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LookoutEquipmentResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDataIngestionJobResponse> {
        public Builder jobId(String var1);

        public Builder datasetArn(String var1);

        public Builder ingestionInputConfiguration(IngestionInputConfiguration var1);

        default public Builder ingestionInputConfiguration(Consumer<IngestionInputConfiguration.Builder> ingestionInputConfiguration) {
            return this.ingestionInputConfiguration((IngestionInputConfiguration)((IngestionInputConfiguration.Builder)IngestionInputConfiguration.builder().applyMutation(ingestionInputConfiguration)).build());
        }

        public Builder roleArn(String var1);

        public Builder createdAt(Instant var1);

        public Builder status(String var1);

        public Builder status(IngestionJobStatus var1);

        public Builder failedReason(String var1);

        public Builder dataQualitySummary(DataQualitySummary var1);

        default public Builder dataQualitySummary(Consumer<DataQualitySummary.Builder> dataQualitySummary) {
            return this.dataQualitySummary((DataQualitySummary)((DataQualitySummary.Builder)DataQualitySummary.builder().applyMutation(dataQualitySummary)).build());
        }

        public Builder ingestedFilesSummary(IngestedFilesSummary var1);

        default public Builder ingestedFilesSummary(Consumer<IngestedFilesSummary.Builder> ingestedFilesSummary) {
            return this.ingestedFilesSummary((IngestedFilesSummary)((IngestedFilesSummary.Builder)IngestedFilesSummary.builder().applyMutation(ingestedFilesSummary)).build());
        }

        public Builder statusDetail(String var1);

        public Builder ingestedDataSize(Long var1);

        public Builder dataStartTime(Instant var1);

        public Builder dataEndTime(Instant var1);

        public Builder sourceDatasetArn(String var1);
    }
}

