/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutequipment.model.LabelRating;
import software.amazon.awssdk.services.lookoutequipment.model.LookoutEquipmentResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLabelResponse
extends LookoutEquipmentResponse
implements ToCopyableBuilder<Builder, DescribeLabelResponse> {
    private static final SdkField<String> LABEL_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LabelGroupName").getter(DescribeLabelResponse.getter(DescribeLabelResponse::labelGroupName)).setter(DescribeLabelResponse.setter(Builder::labelGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelGroupName").build()}).build();
    private static final SdkField<String> LABEL_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LabelGroupArn").getter(DescribeLabelResponse.getter(DescribeLabelResponse::labelGroupArn)).setter(DescribeLabelResponse.setter(Builder::labelGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelGroupArn").build()}).build();
    private static final SdkField<String> LABEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LabelId").getter(DescribeLabelResponse.getter(DescribeLabelResponse::labelId)).setter(DescribeLabelResponse.setter(Builder::labelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelId").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(DescribeLabelResponse.getter(DescribeLabelResponse::startTime)).setter(DescribeLabelResponse.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(DescribeLabelResponse.getter(DescribeLabelResponse::endTime)).setter(DescribeLabelResponse.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<String> RATING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Rating").getter(DescribeLabelResponse.getter(DescribeLabelResponse::ratingAsString)).setter(DescribeLabelResponse.setter(Builder::rating)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rating").build()}).build();
    private static final SdkField<String> FAULT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FaultCode").getter(DescribeLabelResponse.getter(DescribeLabelResponse::faultCode)).setter(DescribeLabelResponse.setter(Builder::faultCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaultCode").build()}).build();
    private static final SdkField<String> NOTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Notes").getter(DescribeLabelResponse.getter(DescribeLabelResponse::notes)).setter(DescribeLabelResponse.setter(Builder::notes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notes").build()}).build();
    private static final SdkField<String> EQUIPMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Equipment").getter(DescribeLabelResponse.getter(DescribeLabelResponse::equipment)).setter(DescribeLabelResponse.setter(Builder::equipment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Equipment").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(DescribeLabelResponse.getter(DescribeLabelResponse::createdAt)).setter(DescribeLabelResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABEL_GROUP_NAME_FIELD, LABEL_GROUP_ARN_FIELD, LABEL_ID_FIELD, START_TIME_FIELD, END_TIME_FIELD, RATING_FIELD, FAULT_CODE_FIELD, NOTES_FIELD, EQUIPMENT_FIELD, CREATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeLabelResponse.memberNameToFieldInitializer();
    private final String labelGroupName;
    private final String labelGroupArn;
    private final String labelId;
    private final Instant startTime;
    private final Instant endTime;
    private final String rating;
    private final String faultCode;
    private final String notes;
    private final String equipment;
    private final Instant createdAt;

    private DescribeLabelResponse(BuilderImpl builder) {
        super(builder);
        this.labelGroupName = builder.labelGroupName;
        this.labelGroupArn = builder.labelGroupArn;
        this.labelId = builder.labelId;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.rating = builder.rating;
        this.faultCode = builder.faultCode;
        this.notes = builder.notes;
        this.equipment = builder.equipment;
        this.createdAt = builder.createdAt;
    }

    public final String labelGroupName() {
        return this.labelGroupName;
    }

    public final String labelGroupArn() {
        return this.labelGroupArn;
    }

    public final String labelId() {
        return this.labelId;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final LabelRating rating() {
        return LabelRating.fromValue(this.rating);
    }

    public final String ratingAsString() {
        return this.rating;
    }

    public final String faultCode() {
        return this.faultCode;
    }

    public final String notes() {
        return this.notes;
    }

    public final String equipment() {
        return this.equipment;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.labelGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.ratingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.faultCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.notes());
        hashCode = 31 * hashCode + Objects.hashCode(this.equipment());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLabelResponse)) {
            return false;
        }
        DescribeLabelResponse other = (DescribeLabelResponse)((Object)obj);
        return Objects.equals(this.labelGroupName(), other.labelGroupName()) && Objects.equals(this.labelGroupArn(), other.labelGroupArn()) && Objects.equals(this.labelId(), other.labelId()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.ratingAsString(), other.ratingAsString()) && Objects.equals(this.faultCode(), other.faultCode()) && Objects.equals(this.notes(), other.notes()) && Objects.equals(this.equipment(), other.equipment()) && Objects.equals(this.createdAt(), other.createdAt());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeLabelResponse").add("LabelGroupName", (Object)this.labelGroupName()).add("LabelGroupArn", (Object)this.labelGroupArn()).add("LabelId", (Object)this.labelId()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("Rating", (Object)this.ratingAsString()).add("FaultCode", (Object)this.faultCode()).add("Notes", (Object)this.notes()).add("Equipment", (Object)this.equipment()).add("CreatedAt", (Object)this.createdAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LabelGroupName": {
                return Optional.ofNullable(clazz.cast(this.labelGroupName()));
            }
            case "LabelGroupArn": {
                return Optional.ofNullable(clazz.cast(this.labelGroupArn()));
            }
            case "LabelId": {
                return Optional.ofNullable(clazz.cast(this.labelId()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "Rating": {
                return Optional.ofNullable(clazz.cast(this.ratingAsString()));
            }
            case "FaultCode": {
                return Optional.ofNullable(clazz.cast(this.faultCode()));
            }
            case "Notes": {
                return Optional.ofNullable(clazz.cast(this.notes()));
            }
            case "Equipment": {
                return Optional.ofNullable(clazz.cast(this.equipment()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LabelGroupName", LABEL_GROUP_NAME_FIELD);
        map.put("LabelGroupArn", LABEL_GROUP_ARN_FIELD);
        map.put("LabelId", LABEL_ID_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("Rating", RATING_FIELD);
        map.put("FaultCode", FAULT_CODE_FIELD);
        map.put("Notes", NOTES_FIELD);
        map.put("Equipment", EQUIPMENT_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeLabelResponse, T> g) {
        return obj -> g.apply((DescribeLabelResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutEquipmentResponse.BuilderImpl
    implements Builder {
        private String labelGroupName;
        private String labelGroupArn;
        private String labelId;
        private Instant startTime;
        private Instant endTime;
        private String rating;
        private String faultCode;
        private String notes;
        private String equipment;
        private Instant createdAt;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLabelResponse model) {
            super(model);
            this.labelGroupName(model.labelGroupName);
            this.labelGroupArn(model.labelGroupArn);
            this.labelId(model.labelId);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.rating(model.rating);
            this.faultCode(model.faultCode);
            this.notes(model.notes);
            this.equipment(model.equipment);
            this.createdAt(model.createdAt);
        }

        public final String getLabelGroupName() {
            return this.labelGroupName;
        }

        public final void setLabelGroupName(String labelGroupName) {
            this.labelGroupName = labelGroupName;
        }

        @Override
        public final Builder labelGroupName(String labelGroupName) {
            this.labelGroupName = labelGroupName;
            return this;
        }

        public final String getLabelGroupArn() {
            return this.labelGroupArn;
        }

        public final void setLabelGroupArn(String labelGroupArn) {
            this.labelGroupArn = labelGroupArn;
        }

        @Override
        public final Builder labelGroupArn(String labelGroupArn) {
            this.labelGroupArn = labelGroupArn;
            return this;
        }

        public final String getLabelId() {
            return this.labelId;
        }

        public final void setLabelId(String labelId) {
            this.labelId = labelId;
        }

        @Override
        public final Builder labelId(String labelId) {
            this.labelId = labelId;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getRating() {
            return this.rating;
        }

        public final void setRating(String rating) {
            this.rating = rating;
        }

        @Override
        public final Builder rating(String rating) {
            this.rating = rating;
            return this;
        }

        @Override
        public final Builder rating(LabelRating rating) {
            this.rating(rating == null ? null : rating.toString());
            return this;
        }

        public final String getFaultCode() {
            return this.faultCode;
        }

        public final void setFaultCode(String faultCode) {
            this.faultCode = faultCode;
        }

        @Override
        public final Builder faultCode(String faultCode) {
            this.faultCode = faultCode;
            return this;
        }

        public final String getNotes() {
            return this.notes;
        }

        public final void setNotes(String notes) {
            this.notes = notes;
        }

        @Override
        public final Builder notes(String notes) {
            this.notes = notes;
            return this;
        }

        public final String getEquipment() {
            return this.equipment;
        }

        public final void setEquipment(String equipment) {
            this.equipment = equipment;
        }

        @Override
        public final Builder equipment(String equipment) {
            this.equipment = equipment;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public DescribeLabelResponse build() {
            return new DescribeLabelResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LookoutEquipmentResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeLabelResponse> {
        public Builder labelGroupName(String var1);

        public Builder labelGroupArn(String var1);

        public Builder labelId(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder rating(String var1);

        public Builder rating(LabelRating var1);

        public Builder faultCode(String var1);

        public Builder notes(String var1);

        public Builder equipment(String var1);

        public Builder createdAt(Instant var1);
    }
}

