/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lookoutequipment.LookoutEquipmentAsyncClient;
import software.amazon.awssdk.services.lookoutequipment.internal.UserAgentUtils;
import software.amazon.awssdk.services.lookoutequipment.model.ListDataIngestionJobsRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ListDataIngestionJobsResponse;

public class ListDataIngestionJobsPublisher
implements SdkPublisher<ListDataIngestionJobsResponse> {
    private final LookoutEquipmentAsyncClient client;
    private final ListDataIngestionJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDataIngestionJobsPublisher(LookoutEquipmentAsyncClient client, ListDataIngestionJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDataIngestionJobsPublisher(LookoutEquipmentAsyncClient client, ListDataIngestionJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDataIngestionJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDataIngestionJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListDataIngestionJobsResponseFetcher
    implements AsyncPageFetcher<ListDataIngestionJobsResponse> {
        private ListDataIngestionJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListDataIngestionJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDataIngestionJobsResponse> nextPage(ListDataIngestionJobsResponse previousPage) {
            if (previousPage == null) {
                return ListDataIngestionJobsPublisher.this.client.listDataIngestionJobs(ListDataIngestionJobsPublisher.this.firstRequest);
            }
            return ListDataIngestionJobsPublisher.this.client.listDataIngestionJobs((ListDataIngestionJobsRequest)((Object)ListDataIngestionJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

