/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lookoutequipment.LookoutEquipmentAsyncClient;
import software.amazon.awssdk.services.lookoutequipment.internal.UserAgentUtils;
import software.amazon.awssdk.services.lookoutequipment.model.ListRetrainingSchedulersRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ListRetrainingSchedulersResponse;

public class ListRetrainingSchedulersPublisher
implements SdkPublisher<ListRetrainingSchedulersResponse> {
    private final LookoutEquipmentAsyncClient client;
    private final ListRetrainingSchedulersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRetrainingSchedulersPublisher(LookoutEquipmentAsyncClient client, ListRetrainingSchedulersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRetrainingSchedulersPublisher(LookoutEquipmentAsyncClient client, ListRetrainingSchedulersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRetrainingSchedulersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRetrainingSchedulersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListRetrainingSchedulersResponseFetcher
    implements AsyncPageFetcher<ListRetrainingSchedulersResponse> {
        private ListRetrainingSchedulersResponseFetcher() {
        }

        public boolean hasNextPage(ListRetrainingSchedulersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRetrainingSchedulersResponse> nextPage(ListRetrainingSchedulersResponse previousPage) {
            if (previousPage == null) {
                return ListRetrainingSchedulersPublisher.this.client.listRetrainingSchedulers(ListRetrainingSchedulersPublisher.this.firstRequest);
            }
            return ListRetrainingSchedulersPublisher.this.client.listRetrainingSchedulers((ListRetrainingSchedulersRequest)((Object)ListRetrainingSchedulersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

