/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.AsyncWaiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.core.waiters.WaiterState;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.mediaconnect.MediaConnectAsyncClient;
import software.amazon.awssdk.services.mediaconnect.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.mediaconnect.model.DescribeFlowRequest;
import software.amazon.awssdk.services.mediaconnect.model.DescribeFlowResponse;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectRequest;
import software.amazon.awssdk.services.mediaconnect.waiters.MediaConnectAsyncWaiter;
import software.amazon.awssdk.services.mediaconnect.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

@SdkInternalApi
@ThreadSafe
final class DefaultMediaConnectAsyncWaiter
implements MediaConnectAsyncWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private static final WaiterAttribute<ScheduledExecutorService> SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE = new WaiterAttribute(ScheduledExecutorService.class);
    private final MediaConnectAsyncClient client;
    private final AttributeMap managedResources;
    private final AsyncWaiter<DescribeFlowResponse> flowActiveWaiter;
    private final AsyncWaiter<DescribeFlowResponse> flowStandbyWaiter;
    private final AsyncWaiter<DescribeFlowResponse> flowDeletedWaiter;
    private final ScheduledExecutorService executorService;

    private DefaultMediaConnectAsyncWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (MediaConnectAsyncClient)MediaConnectAsyncClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        if (builder.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().threadNamePrefix("waiters-ScheduledExecutor").build());
            attributeMapBuilder.put(SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE, (Object)this.executorService);
        } else {
            this.executorService = builder.executorService;
        }
        this.managedResources = attributeMapBuilder.build();
        this.flowActiveWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeFlowResponse.class).acceptors(DefaultMediaConnectAsyncWaiter.flowActiveWaiterAcceptors())).overrideConfiguration(DefaultMediaConnectAsyncWaiter.flowActiveWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.flowStandbyWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeFlowResponse.class).acceptors(DefaultMediaConnectAsyncWaiter.flowStandbyWaiterAcceptors())).overrideConfiguration(DefaultMediaConnectAsyncWaiter.flowStandbyWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.flowDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeFlowResponse.class).acceptors(DefaultMediaConnectAsyncWaiter.flowDeletedWaiterAcceptors())).overrideConfiguration(DefaultMediaConnectAsyncWaiter.flowDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeFlowResponse>> waitUntilFlowActive(DescribeFlowRequest describeFlowRequest) {
        return this.flowActiveWaiter.runAsync(() -> this.client.describeFlow(this.applyWaitersUserAgent(describeFlowRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeFlowResponse>> waitUntilFlowActive(DescribeFlowRequest describeFlowRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.flowActiveWaiter.runAsync(() -> this.client.describeFlow(this.applyWaitersUserAgent(describeFlowRequest)), DefaultMediaConnectAsyncWaiter.flowActiveWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeFlowResponse>> waitUntilFlowDeleted(DescribeFlowRequest describeFlowRequest) {
        return this.flowDeletedWaiter.runAsync(() -> this.client.describeFlow(this.applyWaitersUserAgent(describeFlowRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeFlowResponse>> waitUntilFlowDeleted(DescribeFlowRequest describeFlowRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.flowDeletedWaiter.runAsync(() -> this.client.describeFlow(this.applyWaitersUserAgent(describeFlowRequest)), DefaultMediaConnectAsyncWaiter.flowDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeFlowResponse>> waitUntilFlowStandby(DescribeFlowRequest describeFlowRequest) {
        return this.flowStandbyWaiter.runAsync(() -> this.client.describeFlow(this.applyWaitersUserAgent(describeFlowRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeFlowResponse>> waitUntilFlowStandby(DescribeFlowRequest describeFlowRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.flowStandbyWaiter.runAsync(() -> this.client.describeFlow(this.applyWaitersUserAgent(describeFlowRequest)), DefaultMediaConnectAsyncWaiter.flowStandbyWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeFlowResponse>> flowActiveWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeFlowResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeFlowResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Flow").field("Status").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Flow").field("Status").value(), "STARTING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Flow").field("Status").value(), "UPDATING");
        }));
        result.add(new WaitersRuntime.ResponseStatusAcceptor(500, WaiterState.RETRY));
        result.add(new WaitersRuntime.ResponseStatusAcceptor(503, WaiterState.RETRY));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Flow").field("Status").value(), "ERROR");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (Flow.Status=ERROR) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeFlowResponse>> flowStandbyWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeFlowResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeFlowResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Flow").field("Status").value(), "STANDBY");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Flow").field("Status").value(), "STOPPING");
        }));
        result.add(new WaitersRuntime.ResponseStatusAcceptor(500, WaiterState.RETRY));
        result.add(new WaitersRuntime.ResponseStatusAcceptor(503, WaiterState.RETRY));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Flow").field("Status").value(), "ERROR");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (Flow.Status=ERROR) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeFlowResponse>> flowDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeFlowResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeFlowResponse>>();
        result.add(new WaitersRuntime.ResponseStatusAcceptor(404, WaiterState.SUCCESS));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Flow").field("Status").value(), "DELETING");
        }));
        result.add(new WaitersRuntime.ResponseStatusAcceptor(500, WaiterState.RETRY));
        result.add(new WaitersRuntime.ResponseStatusAcceptor(503, WaiterState.RETRY));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Flow").field("Status").value(), "ERROR");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (Flow.Status=ERROR) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration flowActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(3L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration flowStandbyWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(3L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration flowDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(3L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static MediaConnectAsyncWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends MediaConnectRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((MediaConnectRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements MediaConnectAsyncWaiter.Builder {
        private MediaConnectAsyncClient client;
        private WaiterOverrideConfiguration overrideConfiguration;
        private ScheduledExecutorService executorService;

        private DefaultBuilder() {
        }

        @Override
        public MediaConnectAsyncWaiter.Builder scheduledExecutorService(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public MediaConnectAsyncWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public MediaConnectAsyncWaiter.Builder client(MediaConnectAsyncClient client) {
            this.client = client;
            return this;
        }

        @Override
        public MediaConnectAsyncWaiter build() {
            return new DefaultMediaConnectAsyncWaiter(this);
        }
    }
}

