/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.PresetSpeke20Audio;
import software.amazon.awssdk.services.mediaconvert.model.PresetSpeke20Video;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EncryptionContractConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EncryptionContractConfiguration> {
    private static final SdkField<String> SPEKE_AUDIO_PRESET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SpekeAudioPreset").getter(EncryptionContractConfiguration.getter(EncryptionContractConfiguration::spekeAudioPresetAsString)).setter(EncryptionContractConfiguration.setter(Builder::spekeAudioPreset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spekeAudioPreset").build()}).build();
    private static final SdkField<String> SPEKE_VIDEO_PRESET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SpekeVideoPreset").getter(EncryptionContractConfiguration.getter(EncryptionContractConfiguration::spekeVideoPresetAsString)).setter(EncryptionContractConfiguration.setter(Builder::spekeVideoPreset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spekeVideoPreset").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPEKE_AUDIO_PRESET_FIELD, SPEKE_VIDEO_PRESET_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("spekeAudioPreset", SPEKE_AUDIO_PRESET_FIELD);
            this.put("spekeVideoPreset", SPEKE_VIDEO_PRESET_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String spekeAudioPreset;
    private final String spekeVideoPreset;

    private EncryptionContractConfiguration(BuilderImpl builder) {
        this.spekeAudioPreset = builder.spekeAudioPreset;
        this.spekeVideoPreset = builder.spekeVideoPreset;
    }

    public final PresetSpeke20Audio spekeAudioPreset() {
        return PresetSpeke20Audio.fromValue(this.spekeAudioPreset);
    }

    public final String spekeAudioPresetAsString() {
        return this.spekeAudioPreset;
    }

    public final PresetSpeke20Video spekeVideoPreset() {
        return PresetSpeke20Video.fromValue(this.spekeVideoPreset);
    }

    public final String spekeVideoPresetAsString() {
        return this.spekeVideoPreset;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.spekeAudioPresetAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.spekeVideoPresetAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptionContractConfiguration)) {
            return false;
        }
        EncryptionContractConfiguration other = (EncryptionContractConfiguration)obj;
        return Objects.equals(this.spekeAudioPresetAsString(), other.spekeAudioPresetAsString()) && Objects.equals(this.spekeVideoPresetAsString(), other.spekeVideoPresetAsString());
    }

    public final String toString() {
        return ToString.builder((String)"EncryptionContractConfiguration").add("SpekeAudioPreset", (Object)this.spekeAudioPresetAsString()).add("SpekeVideoPreset", (Object)this.spekeVideoPresetAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SpekeAudioPreset": {
                return Optional.ofNullable(clazz.cast(this.spekeAudioPresetAsString()));
            }
            case "SpekeVideoPreset": {
                return Optional.ofNullable(clazz.cast(this.spekeVideoPresetAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EncryptionContractConfiguration, T> g) {
        return obj -> g.apply((EncryptionContractConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String spekeAudioPreset;
        private String spekeVideoPreset;

        private BuilderImpl() {
        }

        private BuilderImpl(EncryptionContractConfiguration model) {
            this.spekeAudioPreset(model.spekeAudioPreset);
            this.spekeVideoPreset(model.spekeVideoPreset);
        }

        public final String getSpekeAudioPreset() {
            return this.spekeAudioPreset;
        }

        public final void setSpekeAudioPreset(String spekeAudioPreset) {
            this.spekeAudioPreset = spekeAudioPreset;
        }

        @Override
        public final Builder spekeAudioPreset(String spekeAudioPreset) {
            this.spekeAudioPreset = spekeAudioPreset;
            return this;
        }

        @Override
        public final Builder spekeAudioPreset(PresetSpeke20Audio spekeAudioPreset) {
            this.spekeAudioPreset(spekeAudioPreset == null ? null : spekeAudioPreset.toString());
            return this;
        }

        public final String getSpekeVideoPreset() {
            return this.spekeVideoPreset;
        }

        public final void setSpekeVideoPreset(String spekeVideoPreset) {
            this.spekeVideoPreset = spekeVideoPreset;
        }

        @Override
        public final Builder spekeVideoPreset(String spekeVideoPreset) {
            this.spekeVideoPreset = spekeVideoPreset;
            return this;
        }

        @Override
        public final Builder spekeVideoPreset(PresetSpeke20Video spekeVideoPreset) {
            this.spekeVideoPreset(spekeVideoPreset == null ? null : spekeVideoPreset.toString());
            return this;
        }

        public EncryptionContractConfiguration build() {
            return new EncryptionContractConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EncryptionContractConfiguration> {
        public Builder spekeAudioPreset(String var1);

        public Builder spekeAudioPreset(PresetSpeke20Audio var1);

        public Builder spekeVideoPreset(String var1);

        public Builder spekeVideoPreset(PresetSpeke20Video var1);
    }
}

