/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconvert.model.InputTimecodeSource;
import software.amazon.awssdk.services.mediaconvert.model.VideoOverlayInputClipping;
import software.amazon.awssdk.services.mediaconvert.model.___listOfVideoOverlayInputClippingCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VideoOverlayInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VideoOverlayInput> {
    private static final SdkField<String> FILE_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileInput").getter(VideoOverlayInput.getter(VideoOverlayInput::fileInput)).setter(VideoOverlayInput.setter(Builder::fileInput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileInput").build()}).build();
    private static final SdkField<List<VideoOverlayInputClipping>> INPUT_CLIPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InputClippings").getter(VideoOverlayInput.getter(VideoOverlayInput::inputClippings)).setter(VideoOverlayInput.setter(Builder::inputClippings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputClippings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VideoOverlayInputClipping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TIMECODE_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimecodeSource").getter(VideoOverlayInput.getter(VideoOverlayInput::timecodeSourceAsString)).setter(VideoOverlayInput.setter(Builder::timecodeSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timecodeSource").build()}).build();
    private static final SdkField<String> TIMECODE_START_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimecodeStart").getter(VideoOverlayInput.getter(VideoOverlayInput::timecodeStart)).setter(VideoOverlayInput.setter(Builder::timecodeStart)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timecodeStart").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_INPUT_FIELD, INPUT_CLIPPINGS_FIELD, TIMECODE_SOURCE_FIELD, TIMECODE_START_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("fileInput", FILE_INPUT_FIELD);
            this.put("inputClippings", INPUT_CLIPPINGS_FIELD);
            this.put("timecodeSource", TIMECODE_SOURCE_FIELD);
            this.put("timecodeStart", TIMECODE_START_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String fileInput;
    private final List<VideoOverlayInputClipping> inputClippings;
    private final String timecodeSource;
    private final String timecodeStart;

    private VideoOverlayInput(BuilderImpl builder) {
        this.fileInput = builder.fileInput;
        this.inputClippings = builder.inputClippings;
        this.timecodeSource = builder.timecodeSource;
        this.timecodeStart = builder.timecodeStart;
    }

    public final String fileInput() {
        return this.fileInput;
    }

    public final boolean hasInputClippings() {
        return this.inputClippings != null && !(this.inputClippings instanceof SdkAutoConstructList);
    }

    public final List<VideoOverlayInputClipping> inputClippings() {
        return this.inputClippings;
    }

    public final InputTimecodeSource timecodeSource() {
        return InputTimecodeSource.fromValue(this.timecodeSource);
    }

    public final String timecodeSourceAsString() {
        return this.timecodeSource;
    }

    public final String timecodeStart() {
        return this.timecodeStart;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fileInput());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputClippings() ? this.inputClippings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.timecodeSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timecodeStart());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoOverlayInput)) {
            return false;
        }
        VideoOverlayInput other = (VideoOverlayInput)obj;
        return Objects.equals(this.fileInput(), other.fileInput()) && this.hasInputClippings() == other.hasInputClippings() && Objects.equals(this.inputClippings(), other.inputClippings()) && Objects.equals(this.timecodeSourceAsString(), other.timecodeSourceAsString()) && Objects.equals(this.timecodeStart(), other.timecodeStart());
    }

    public final String toString() {
        return ToString.builder((String)"VideoOverlayInput").add("FileInput", (Object)this.fileInput()).add("InputClippings", this.hasInputClippings() ? this.inputClippings() : null).add("TimecodeSource", (Object)this.timecodeSourceAsString()).add("TimecodeStart", (Object)this.timecodeStart()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FileInput": {
                return Optional.ofNullable(clazz.cast(this.fileInput()));
            }
            case "InputClippings": {
                return Optional.ofNullable(clazz.cast(this.inputClippings()));
            }
            case "TimecodeSource": {
                return Optional.ofNullable(clazz.cast(this.timecodeSourceAsString()));
            }
            case "TimecodeStart": {
                return Optional.ofNullable(clazz.cast(this.timecodeStart()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<VideoOverlayInput, T> g) {
        return obj -> g.apply((VideoOverlayInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fileInput;
        private List<VideoOverlayInputClipping> inputClippings = DefaultSdkAutoConstructList.getInstance();
        private String timecodeSource;
        private String timecodeStart;

        private BuilderImpl() {
        }

        private BuilderImpl(VideoOverlayInput model) {
            this.fileInput(model.fileInput);
            this.inputClippings(model.inputClippings);
            this.timecodeSource(model.timecodeSource);
            this.timecodeStart(model.timecodeStart);
        }

        public final String getFileInput() {
            return this.fileInput;
        }

        public final void setFileInput(String fileInput) {
            this.fileInput = fileInput;
        }

        @Override
        public final Builder fileInput(String fileInput) {
            this.fileInput = fileInput;
            return this;
        }

        public final List<VideoOverlayInputClipping.Builder> getInputClippings() {
            List<VideoOverlayInputClipping.Builder> result = ___listOfVideoOverlayInputClippingCopier.copyToBuilder(this.inputClippings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputClippings(Collection<VideoOverlayInputClipping.BuilderImpl> inputClippings) {
            this.inputClippings = ___listOfVideoOverlayInputClippingCopier.copyFromBuilder(inputClippings);
        }

        @Override
        public final Builder inputClippings(Collection<VideoOverlayInputClipping> inputClippings) {
            this.inputClippings = ___listOfVideoOverlayInputClippingCopier.copy(inputClippings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputClippings(VideoOverlayInputClipping ... inputClippings) {
            this.inputClippings(Arrays.asList(inputClippings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputClippings(Consumer<VideoOverlayInputClipping.Builder> ... inputClippings) {
            this.inputClippings(Stream.of(inputClippings).map(c -> (VideoOverlayInputClipping)((VideoOverlayInputClipping.Builder)VideoOverlayInputClipping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTimecodeSource() {
            return this.timecodeSource;
        }

        public final void setTimecodeSource(String timecodeSource) {
            this.timecodeSource = timecodeSource;
        }

        @Override
        public final Builder timecodeSource(String timecodeSource) {
            this.timecodeSource = timecodeSource;
            return this;
        }

        @Override
        public final Builder timecodeSource(InputTimecodeSource timecodeSource) {
            this.timecodeSource(timecodeSource == null ? null : timecodeSource.toString());
            return this;
        }

        public final String getTimecodeStart() {
            return this.timecodeStart;
        }

        public final void setTimecodeStart(String timecodeStart) {
            this.timecodeStart = timecodeStart;
        }

        @Override
        public final Builder timecodeStart(String timecodeStart) {
            this.timecodeStart = timecodeStart;
            return this;
        }

        public VideoOverlayInput build() {
            return new VideoOverlayInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VideoOverlayInput> {
        public Builder fileInput(String var1);

        public Builder inputClippings(Collection<VideoOverlayInputClipping> var1);

        public Builder inputClippings(VideoOverlayInputClipping ... var1);

        public Builder inputClippings(Consumer<VideoOverlayInputClipping.Builder> ... var1);

        public Builder timecodeSource(String var1);

        public Builder timecodeSource(InputTimecodeSource var1);

        public Builder timecodeStart(String var1);
    }
}

