/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medicalimaging.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medicalimaging.model.ImageSetState;
import software.amazon.awssdk.services.medicalimaging.model.ImageSetWorkflowStatus;
import software.amazon.awssdk.services.medicalimaging.model.MedicalImagingResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateImageSetMetadataResponse
extends MedicalImagingResponse
implements ToCopyableBuilder<Builder, UpdateImageSetMetadataResponse> {
    private static final SdkField<String> DATASTORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datastoreId").getter(UpdateImageSetMetadataResponse.getter(UpdateImageSetMetadataResponse::datastoreId)).setter(UpdateImageSetMetadataResponse.setter(Builder::datastoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datastoreId").build()}).build();
    private static final SdkField<String> IMAGE_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageSetId").getter(UpdateImageSetMetadataResponse.getter(UpdateImageSetMetadataResponse::imageSetId)).setter(UpdateImageSetMetadataResponse.setter(Builder::imageSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageSetId").build()}).build();
    private static final SdkField<String> LATEST_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("latestVersionId").getter(UpdateImageSetMetadataResponse.getter(UpdateImageSetMetadataResponse::latestVersionId)).setter(UpdateImageSetMetadataResponse.setter(Builder::latestVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestVersionId").build()}).build();
    private static final SdkField<String> IMAGE_SET_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageSetState").getter(UpdateImageSetMetadataResponse.getter(UpdateImageSetMetadataResponse::imageSetStateAsString)).setter(UpdateImageSetMetadataResponse.setter(Builder::imageSetState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageSetState").build()}).build();
    private static final SdkField<String> IMAGE_SET_WORKFLOW_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageSetWorkflowStatus").getter(UpdateImageSetMetadataResponse.getter(UpdateImageSetMetadataResponse::imageSetWorkflowStatusAsString)).setter(UpdateImageSetMetadataResponse.setter(Builder::imageSetWorkflowStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageSetWorkflowStatus").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(UpdateImageSetMetadataResponse.getter(UpdateImageSetMetadataResponse::createdAt)).setter(UpdateImageSetMetadataResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(UpdateImageSetMetadataResponse.getter(UpdateImageSetMetadataResponse::updatedAt)).setter(UpdateImageSetMetadataResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(UpdateImageSetMetadataResponse.getter(UpdateImageSetMetadataResponse::message)).setter(UpdateImageSetMetadataResponse.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASTORE_ID_FIELD, IMAGE_SET_ID_FIELD, LATEST_VERSION_ID_FIELD, IMAGE_SET_STATE_FIELD, IMAGE_SET_WORKFLOW_STATUS_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, MESSAGE_FIELD));
    private final String datastoreId;
    private final String imageSetId;
    private final String latestVersionId;
    private final String imageSetState;
    private final String imageSetWorkflowStatus;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final String message;

    private UpdateImageSetMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.datastoreId = builder.datastoreId;
        this.imageSetId = builder.imageSetId;
        this.latestVersionId = builder.latestVersionId;
        this.imageSetState = builder.imageSetState;
        this.imageSetWorkflowStatus = builder.imageSetWorkflowStatus;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.message = builder.message;
    }

    public final String datastoreId() {
        return this.datastoreId;
    }

    public final String imageSetId() {
        return this.imageSetId;
    }

    public final String latestVersionId() {
        return this.latestVersionId;
    }

    public final ImageSetState imageSetState() {
        return ImageSetState.fromValue(this.imageSetState);
    }

    public final String imageSetStateAsString() {
        return this.imageSetState;
    }

    public final ImageSetWorkflowStatus imageSetWorkflowStatus() {
        return ImageSetWorkflowStatus.fromValue(this.imageSetWorkflowStatus);
    }

    public final String imageSetWorkflowStatusAsString() {
        return this.imageSetWorkflowStatus;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String message() {
        return this.message;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.datastoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageSetStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageSetWorkflowStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateImageSetMetadataResponse)) {
            return false;
        }
        UpdateImageSetMetadataResponse other = (UpdateImageSetMetadataResponse)((Object)obj);
        return Objects.equals(this.datastoreId(), other.datastoreId()) && Objects.equals(this.imageSetId(), other.imageSetId()) && Objects.equals(this.latestVersionId(), other.latestVersionId()) && Objects.equals(this.imageSetStateAsString(), other.imageSetStateAsString()) && Objects.equals(this.imageSetWorkflowStatusAsString(), other.imageSetWorkflowStatusAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.message(), other.message());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateImageSetMetadataResponse").add("DatastoreId", (Object)this.datastoreId()).add("ImageSetId", (Object)this.imageSetId()).add("LatestVersionId", (Object)this.latestVersionId()).add("ImageSetState", (Object)this.imageSetStateAsString()).add("ImageSetWorkflowStatus", (Object)this.imageSetWorkflowStatusAsString()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("Message", (Object)this.message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "datastoreId": {
                return Optional.ofNullable(clazz.cast(this.datastoreId()));
            }
            case "imageSetId": {
                return Optional.ofNullable(clazz.cast(this.imageSetId()));
            }
            case "latestVersionId": {
                return Optional.ofNullable(clazz.cast(this.latestVersionId()));
            }
            case "imageSetState": {
                return Optional.ofNullable(clazz.cast(this.imageSetStateAsString()));
            }
            case "imageSetWorkflowStatus": {
                return Optional.ofNullable(clazz.cast(this.imageSetWorkflowStatusAsString()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateImageSetMetadataResponse, T> g) {
        return obj -> g.apply((UpdateImageSetMetadataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MedicalImagingResponse.BuilderImpl
    implements Builder {
        private String datastoreId;
        private String imageSetId;
        private String latestVersionId;
        private String imageSetState;
        private String imageSetWorkflowStatus;
        private Instant createdAt;
        private Instant updatedAt;
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateImageSetMetadataResponse model) {
            super(model);
            this.datastoreId(model.datastoreId);
            this.imageSetId(model.imageSetId);
            this.latestVersionId(model.latestVersionId);
            this.imageSetState(model.imageSetState);
            this.imageSetWorkflowStatus(model.imageSetWorkflowStatus);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.message(model.message);
        }

        public final String getDatastoreId() {
            return this.datastoreId;
        }

        public final void setDatastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
        }

        @Override
        public final Builder datastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
            return this;
        }

        public final String getImageSetId() {
            return this.imageSetId;
        }

        public final void setImageSetId(String imageSetId) {
            this.imageSetId = imageSetId;
        }

        @Override
        public final Builder imageSetId(String imageSetId) {
            this.imageSetId = imageSetId;
            return this;
        }

        public final String getLatestVersionId() {
            return this.latestVersionId;
        }

        public final void setLatestVersionId(String latestVersionId) {
            this.latestVersionId = latestVersionId;
        }

        @Override
        public final Builder latestVersionId(String latestVersionId) {
            this.latestVersionId = latestVersionId;
            return this;
        }

        public final String getImageSetState() {
            return this.imageSetState;
        }

        public final void setImageSetState(String imageSetState) {
            this.imageSetState = imageSetState;
        }

        @Override
        public final Builder imageSetState(String imageSetState) {
            this.imageSetState = imageSetState;
            return this;
        }

        @Override
        public final Builder imageSetState(ImageSetState imageSetState) {
            this.imageSetState(imageSetState == null ? null : imageSetState.toString());
            return this;
        }

        public final String getImageSetWorkflowStatus() {
            return this.imageSetWorkflowStatus;
        }

        public final void setImageSetWorkflowStatus(String imageSetWorkflowStatus) {
            this.imageSetWorkflowStatus = imageSetWorkflowStatus;
        }

        @Override
        public final Builder imageSetWorkflowStatus(String imageSetWorkflowStatus) {
            this.imageSetWorkflowStatus = imageSetWorkflowStatus;
            return this;
        }

        @Override
        public final Builder imageSetWorkflowStatus(ImageSetWorkflowStatus imageSetWorkflowStatus) {
            this.imageSetWorkflowStatus(imageSetWorkflowStatus == null ? null : imageSetWorkflowStatus.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public UpdateImageSetMetadataResponse build() {
            return new UpdateImageSetMetadataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MedicalImagingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateImageSetMetadataResponse> {
        public Builder datastoreId(String var1);

        public Builder imageSetId(String var1);

        public Builder latestVersionId(String var1);

        public Builder imageSetState(String var1);

        public Builder imageSetState(ImageSetState var1);

        public Builder imageSetWorkflowStatus(String var1);

        public Builder imageSetWorkflowStatus(ImageSetWorkflowStatus var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder message(String var1);
    }
}

