/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmonitor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.networkmonitor.model.Protocol;
import software.amazon.awssdk.services.networkmonitor.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMonitorProbeInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CreateMonitorProbeInput> {
    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceArn").getter(CreateMonitorProbeInput.getter(CreateMonitorProbeInput::sourceArn)).setter(CreateMonitorProbeInput.setter(Builder::sourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceArn").build()}).build();
    private static final SdkField<String> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destination").getter(CreateMonitorProbeInput.getter(CreateMonitorProbeInput::destination)).setter(CreateMonitorProbeInput.setter(Builder::destination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()}).build();
    private static final SdkField<Integer> DESTINATION_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("destinationPort").getter(CreateMonitorProbeInput.getter(CreateMonitorProbeInput::destinationPort)).setter(CreateMonitorProbeInput.setter(Builder::destinationPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationPort").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("protocol").getter(CreateMonitorProbeInput.getter(CreateMonitorProbeInput::protocolAsString)).setter(CreateMonitorProbeInput.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()}).build();
    private static final SdkField<Integer> PACKET_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("packetSize").getter(CreateMonitorProbeInput.getter(CreateMonitorProbeInput::packetSize)).setter(CreateMonitorProbeInput.setter(Builder::packetSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packetSize").build()}).build();
    private static final SdkField<Map<String, String>> PROBE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("probeTags").getter(CreateMonitorProbeInput.getter(CreateMonitorProbeInput::probeTags)).setter(CreateMonitorProbeInput.setter(Builder::probeTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("probeTags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_ARN_FIELD, DESTINATION_FIELD, DESTINATION_PORT_FIELD, PROTOCOL_FIELD, PACKET_SIZE_FIELD, PROBE_TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateMonitorProbeInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String sourceArn;
    private final String destination;
    private final Integer destinationPort;
    private final String protocol;
    private final Integer packetSize;
    private final Map<String, String> probeTags;

    private CreateMonitorProbeInput(BuilderImpl builder) {
        this.sourceArn = builder.sourceArn;
        this.destination = builder.destination;
        this.destinationPort = builder.destinationPort;
        this.protocol = builder.protocol;
        this.packetSize = builder.packetSize;
        this.probeTags = builder.probeTags;
    }

    public final String sourceArn() {
        return this.sourceArn;
    }

    public final String destination() {
        return this.destination;
    }

    public final Integer destinationPort() {
        return this.destinationPort;
    }

    public final Protocol protocol() {
        return Protocol.fromValue(this.protocol);
    }

    public final String protocolAsString() {
        return this.protocol;
    }

    public final Integer packetSize() {
        return this.packetSize;
    }

    public final boolean hasProbeTags() {
        return this.probeTags != null && !(this.probeTags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> probeTags() {
        return this.probeTags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.packetSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProbeTags() ? this.probeTags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMonitorProbeInput)) {
            return false;
        }
        CreateMonitorProbeInput other = (CreateMonitorProbeInput)obj;
        return Objects.equals(this.sourceArn(), other.sourceArn()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.destinationPort(), other.destinationPort()) && Objects.equals(this.protocolAsString(), other.protocolAsString()) && Objects.equals(this.packetSize(), other.packetSize()) && this.hasProbeTags() == other.hasProbeTags() && Objects.equals(this.probeTags(), other.probeTags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateMonitorProbeInput").add("SourceArn", (Object)this.sourceArn()).add("Destination", (Object)this.destination()).add("DestinationPort", (Object)this.destinationPort()).add("Protocol", (Object)this.protocolAsString()).add("PacketSize", (Object)this.packetSize()).add("ProbeTags", this.hasProbeTags() ? this.probeTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sourceArn": {
                return Optional.ofNullable(clazz.cast(this.sourceArn()));
            }
            case "destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "destinationPort": {
                return Optional.ofNullable(clazz.cast(this.destinationPort()));
            }
            case "protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "packetSize": {
                return Optional.ofNullable(clazz.cast(this.packetSize()));
            }
            case "probeTags": {
                return Optional.ofNullable(clazz.cast(this.probeTags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sourceArn", SOURCE_ARN_FIELD);
        map.put("destination", DESTINATION_FIELD);
        map.put("destinationPort", DESTINATION_PORT_FIELD);
        map.put("protocol", PROTOCOL_FIELD);
        map.put("packetSize", PACKET_SIZE_FIELD);
        map.put("probeTags", PROBE_TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMonitorProbeInput, T> g) {
        return obj -> g.apply((CreateMonitorProbeInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceArn;
        private String destination;
        private Integer destinationPort;
        private String protocol;
        private Integer packetSize;
        private Map<String, String> probeTags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMonitorProbeInput model) {
            this.sourceArn(model.sourceArn);
            this.destination(model.destination);
            this.destinationPort(model.destinationPort);
            this.protocol(model.protocol);
            this.packetSize(model.packetSize);
            this.probeTags(model.probeTags);
        }

        public final String getSourceArn() {
            return this.sourceArn;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final String getDestination() {
            return this.destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final Integer getDestinationPort() {
            return this.destinationPort;
        }

        public final void setDestinationPort(Integer destinationPort) {
            this.destinationPort = destinationPort;
        }

        @Override
        public final Builder destinationPort(Integer destinationPort) {
            this.destinationPort = destinationPort;
            return this;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(Protocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final Integer getPacketSize() {
            return this.packetSize;
        }

        public final void setPacketSize(Integer packetSize) {
            this.packetSize = packetSize;
        }

        @Override
        public final Builder packetSize(Integer packetSize) {
            this.packetSize = packetSize;
            return this;
        }

        public final Map<String, String> getProbeTags() {
            if (this.probeTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.probeTags;
        }

        public final void setProbeTags(Map<String, String> probeTags) {
            this.probeTags = TagMapCopier.copy(probeTags);
        }

        @Override
        public final Builder probeTags(Map<String, String> probeTags) {
            this.probeTags = TagMapCopier.copy(probeTags);
            return this;
        }

        public CreateMonitorProbeInput build() {
            return new CreateMonitorProbeInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CreateMonitorProbeInput> {
        public Builder sourceArn(String var1);

        public Builder destination(String var1);

        public Builder destinationPort(Integer var1);

        public Builder protocol(String var1);

        public Builder protocol(Protocol var1);

        public Builder packetSize(Integer var1);

        public Builder probeTags(Map<String, String> var1);
    }
}

