/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StreamingInstanceType {
    G4_DN_XLARGE("g4dn.xlarge"),
    G4_DN_2_XLARGE("g4dn.2xlarge"),
    G4_DN_4_XLARGE("g4dn.4xlarge"),
    G4_DN_8_XLARGE("g4dn.8xlarge"),
    G4_DN_12_XLARGE("g4dn.12xlarge"),
    G4_DN_16_XLARGE("g4dn.16xlarge"),
    G3_4_XLARGE("g3.4xlarge"),
    G3_S_XLARGE("g3s.xlarge"),
    G5_XLARGE("g5.xlarge"),
    G5_2_XLARGE("g5.2xlarge"),
    G5_4_XLARGE("g5.4xlarge"),
    G5_8_XLARGE("g5.8xlarge"),
    G5_16_XLARGE("g5.16xlarge"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StreamingInstanceType> VALUE_MAP;
    private final String value;

    private StreamingInstanceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StreamingInstanceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StreamingInstanceType> knownValues() {
        EnumSet<StreamingInstanceType> knownValues = EnumSet.allOf(StreamingInstanceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StreamingInstanceType.class, StreamingInstanceType::toString);
    }
}

