/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearchserverless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opensearchserverless.model.OpenSearchServerlessResponse;
import software.amazon.awssdk.services.opensearchserverless.model.VpcEndpointDetail;
import software.amazon.awssdk.services.opensearchserverless.model.VpcEndpointDetailsCopier;
import software.amazon.awssdk.services.opensearchserverless.model.VpcEndpointErrorDetail;
import software.amazon.awssdk.services.opensearchserverless.model.VpcEndpointErrorDetailsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetVpcEndpointResponse
extends OpenSearchServerlessResponse
implements ToCopyableBuilder<Builder, BatchGetVpcEndpointResponse> {
    private static final SdkField<List<VpcEndpointDetail>> VPC_ENDPOINT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("vpcEndpointDetails").getter(BatchGetVpcEndpointResponse.getter(BatchGetVpcEndpointResponse::vpcEndpointDetails)).setter(BatchGetVpcEndpointResponse.setter(Builder::vpcEndpointDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcEndpointDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VpcEndpointDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<VpcEndpointErrorDetail>> VPC_ENDPOINT_ERROR_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("vpcEndpointErrorDetails").getter(BatchGetVpcEndpointResponse.getter(BatchGetVpcEndpointResponse::vpcEndpointErrorDetails)).setter(BatchGetVpcEndpointResponse.setter(Builder::vpcEndpointErrorDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcEndpointErrorDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VpcEndpointErrorDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_ENDPOINT_DETAILS_FIELD, VPC_ENDPOINT_ERROR_DETAILS_FIELD));
    private final List<VpcEndpointDetail> vpcEndpointDetails;
    private final List<VpcEndpointErrorDetail> vpcEndpointErrorDetails;

    private BatchGetVpcEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.vpcEndpointDetails = builder.vpcEndpointDetails;
        this.vpcEndpointErrorDetails = builder.vpcEndpointErrorDetails;
    }

    public final boolean hasVpcEndpointDetails() {
        return this.vpcEndpointDetails != null && !(this.vpcEndpointDetails instanceof SdkAutoConstructList);
    }

    public final List<VpcEndpointDetail> vpcEndpointDetails() {
        return this.vpcEndpointDetails;
    }

    public final boolean hasVpcEndpointErrorDetails() {
        return this.vpcEndpointErrorDetails != null && !(this.vpcEndpointErrorDetails instanceof SdkAutoConstructList);
    }

    public final List<VpcEndpointErrorDetail> vpcEndpointErrorDetails() {
        return this.vpcEndpointErrorDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcEndpointDetails() ? this.vpcEndpointDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcEndpointErrorDetails() ? this.vpcEndpointErrorDetails() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetVpcEndpointResponse)) {
            return false;
        }
        BatchGetVpcEndpointResponse other = (BatchGetVpcEndpointResponse)((Object)obj);
        return this.hasVpcEndpointDetails() == other.hasVpcEndpointDetails() && Objects.equals(this.vpcEndpointDetails(), other.vpcEndpointDetails()) && this.hasVpcEndpointErrorDetails() == other.hasVpcEndpointErrorDetails() && Objects.equals(this.vpcEndpointErrorDetails(), other.vpcEndpointErrorDetails());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetVpcEndpointResponse").add("VpcEndpointDetails", this.hasVpcEndpointDetails() ? this.vpcEndpointDetails() : null).add("VpcEndpointErrorDetails", this.hasVpcEndpointErrorDetails() ? this.vpcEndpointErrorDetails() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "vpcEndpointDetails": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointDetails()));
            }
            case "vpcEndpointErrorDetails": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointErrorDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetVpcEndpointResponse, T> g) {
        return obj -> g.apply((BatchGetVpcEndpointResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpenSearchServerlessResponse.BuilderImpl
    implements Builder {
        private List<VpcEndpointDetail> vpcEndpointDetails = DefaultSdkAutoConstructList.getInstance();
        private List<VpcEndpointErrorDetail> vpcEndpointErrorDetails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetVpcEndpointResponse model) {
            super(model);
            this.vpcEndpointDetails(model.vpcEndpointDetails);
            this.vpcEndpointErrorDetails(model.vpcEndpointErrorDetails);
        }

        public final List<VpcEndpointDetail.Builder> getVpcEndpointDetails() {
            List<VpcEndpointDetail.Builder> result = VpcEndpointDetailsCopier.copyToBuilder(this.vpcEndpointDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcEndpointDetails(Collection<VpcEndpointDetail.BuilderImpl> vpcEndpointDetails) {
            this.vpcEndpointDetails = VpcEndpointDetailsCopier.copyFromBuilder(vpcEndpointDetails);
        }

        @Override
        public final Builder vpcEndpointDetails(Collection<VpcEndpointDetail> vpcEndpointDetails) {
            this.vpcEndpointDetails = VpcEndpointDetailsCopier.copy(vpcEndpointDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcEndpointDetails(VpcEndpointDetail ... vpcEndpointDetails) {
            this.vpcEndpointDetails(Arrays.asList(vpcEndpointDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcEndpointDetails(Consumer<VpcEndpointDetail.Builder> ... vpcEndpointDetails) {
            this.vpcEndpointDetails(Stream.of(vpcEndpointDetails).map(c -> (VpcEndpointDetail)((VpcEndpointDetail.Builder)VpcEndpointDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<VpcEndpointErrorDetail.Builder> getVpcEndpointErrorDetails() {
            List<VpcEndpointErrorDetail.Builder> result = VpcEndpointErrorDetailsCopier.copyToBuilder(this.vpcEndpointErrorDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcEndpointErrorDetails(Collection<VpcEndpointErrorDetail.BuilderImpl> vpcEndpointErrorDetails) {
            this.vpcEndpointErrorDetails = VpcEndpointErrorDetailsCopier.copyFromBuilder(vpcEndpointErrorDetails);
        }

        @Override
        public final Builder vpcEndpointErrorDetails(Collection<VpcEndpointErrorDetail> vpcEndpointErrorDetails) {
            this.vpcEndpointErrorDetails = VpcEndpointErrorDetailsCopier.copy(vpcEndpointErrorDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcEndpointErrorDetails(VpcEndpointErrorDetail ... vpcEndpointErrorDetails) {
            this.vpcEndpointErrorDetails(Arrays.asList(vpcEndpointErrorDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcEndpointErrorDetails(Consumer<VpcEndpointErrorDetail.Builder> ... vpcEndpointErrorDetails) {
            this.vpcEndpointErrorDetails(Stream.of(vpcEndpointErrorDetails).map(c -> (VpcEndpointErrorDetail)((VpcEndpointErrorDetail.Builder)VpcEndpointErrorDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetVpcEndpointResponse build() {
            return new BatchGetVpcEndpointResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OpenSearchServerlessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetVpcEndpointResponse> {
        public Builder vpcEndpointDetails(Collection<VpcEndpointDetail> var1);

        public Builder vpcEndpointDetails(VpcEndpointDetail ... var1);

        public Builder vpcEndpointDetails(Consumer<VpcEndpointDetail.Builder> ... var1);

        public Builder vpcEndpointErrorDetails(Collection<VpcEndpointErrorDetail> var1);

        public Builder vpcEndpointErrorDetails(VpcEndpointErrorDetail ... var1);

        public Builder vpcEndpointErrorDetails(Consumer<VpcEndpointErrorDetail.Builder> ... var1);
    }
}

