/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptography.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.paymentcryptography.model.KeyAttributes;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RootCertificatePublicKey
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RootCertificatePublicKey> {
    private static final SdkField<KeyAttributes> KEY_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KeyAttributes").getter(RootCertificatePublicKey.getter(RootCertificatePublicKey::keyAttributes)).setter(RootCertificatePublicKey.setter(Builder::keyAttributes)).constructor(KeyAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyAttributes").build()}).build();
    private static final SdkField<String> PUBLIC_KEY_CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublicKeyCertificate").getter(RootCertificatePublicKey.getter(RootCertificatePublicKey::publicKeyCertificate)).setter(RootCertificatePublicKey.setter(Builder::publicKeyCertificate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicKeyCertificate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ATTRIBUTES_FIELD, PUBLIC_KEY_CERTIFICATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RootCertificatePublicKey.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final KeyAttributes keyAttributes;
    private final String publicKeyCertificate;

    private RootCertificatePublicKey(BuilderImpl builder) {
        this.keyAttributes = builder.keyAttributes;
        this.publicKeyCertificate = builder.publicKeyCertificate;
    }

    public final KeyAttributes keyAttributes() {
        return this.keyAttributes;
    }

    public final String publicKeyCertificate() {
        return this.publicKeyCertificate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keyAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicKeyCertificate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RootCertificatePublicKey)) {
            return false;
        }
        RootCertificatePublicKey other = (RootCertificatePublicKey)obj;
        return Objects.equals(this.keyAttributes(), other.keyAttributes()) && Objects.equals(this.publicKeyCertificate(), other.publicKeyCertificate());
    }

    public final String toString() {
        return ToString.builder((String)"RootCertificatePublicKey").add("KeyAttributes", (Object)this.keyAttributes()).add("PublicKeyCertificate", (Object)(this.publicKeyCertificate() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyAttributes": {
                return Optional.ofNullable(clazz.cast(this.keyAttributes()));
            }
            case "PublicKeyCertificate": {
                return Optional.ofNullable(clazz.cast(this.publicKeyCertificate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("KeyAttributes", KEY_ATTRIBUTES_FIELD);
        map.put("PublicKeyCertificate", PUBLIC_KEY_CERTIFICATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RootCertificatePublicKey, T> g) {
        return obj -> g.apply((RootCertificatePublicKey)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private KeyAttributes keyAttributes;
        private String publicKeyCertificate;

        private BuilderImpl() {
        }

        private BuilderImpl(RootCertificatePublicKey model) {
            this.keyAttributes(model.keyAttributes);
            this.publicKeyCertificate(model.publicKeyCertificate);
        }

        public final KeyAttributes.Builder getKeyAttributes() {
            return this.keyAttributes != null ? this.keyAttributes.toBuilder() : null;
        }

        public final void setKeyAttributes(KeyAttributes.BuilderImpl keyAttributes) {
            this.keyAttributes = keyAttributes != null ? keyAttributes.build() : null;
        }

        @Override
        public final Builder keyAttributes(KeyAttributes keyAttributes) {
            this.keyAttributes = keyAttributes;
            return this;
        }

        public final String getPublicKeyCertificate() {
            return this.publicKeyCertificate;
        }

        public final void setPublicKeyCertificate(String publicKeyCertificate) {
            this.publicKeyCertificate = publicKeyCertificate;
        }

        @Override
        public final Builder publicKeyCertificate(String publicKeyCertificate) {
            this.publicKeyCertificate = publicKeyCertificate;
            return this;
        }

        public RootCertificatePublicKey build() {
            return new RootCertificatePublicKey(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RootCertificatePublicKey> {
        public Builder keyAttributes(KeyAttributes var1);

        default public Builder keyAttributes(Consumer<KeyAttributes.Builder> keyAttributes) {
            return this.keyAttributes((KeyAttributes)((KeyAttributes.Builder)KeyAttributes.builder().applyMutation(keyAttributes)).build());
        }

        public Builder publicKeyCertificate(String var1);
    }
}

