/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Response;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SpendLimit;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SpendLimitListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSpendLimitsResponse
extends PinpointSmsVoiceV2Response
implements ToCopyableBuilder<Builder, DescribeSpendLimitsResponse> {
    private static final SdkField<List<SpendLimit>> SPEND_LIMITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SpendLimits").getter(DescribeSpendLimitsResponse.getter(DescribeSpendLimitsResponse::spendLimits)).setter(DescribeSpendLimitsResponse.setter(Builder::spendLimits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpendLimits").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SpendLimit::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeSpendLimitsResponse.getter(DescribeSpendLimitsResponse::nextToken)).setter(DescribeSpendLimitsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPEND_LIMITS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("SpendLimits", SPEND_LIMITS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<SpendLimit> spendLimits;
    private final String nextToken;

    private DescribeSpendLimitsResponse(BuilderImpl builder) {
        super(builder);
        this.spendLimits = builder.spendLimits;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSpendLimits() {
        return this.spendLimits != null && !(this.spendLimits instanceof SdkAutoConstructList);
    }

    public final List<SpendLimit> spendLimits() {
        return this.spendLimits;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSpendLimits() ? this.spendLimits() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSpendLimitsResponse)) {
            return false;
        }
        DescribeSpendLimitsResponse other = (DescribeSpendLimitsResponse)((Object)obj);
        return this.hasSpendLimits() == other.hasSpendLimits() && Objects.equals(this.spendLimits(), other.spendLimits()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeSpendLimitsResponse").add("SpendLimits", this.hasSpendLimits() ? this.spendLimits() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SpendLimits": {
                return Optional.ofNullable(clazz.cast(this.spendLimits()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSpendLimitsResponse, T> g) {
        return obj -> g.apply((DescribeSpendLimitsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointSmsVoiceV2Response.BuilderImpl
    implements Builder {
        private List<SpendLimit> spendLimits = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSpendLimitsResponse model) {
            super(model);
            this.spendLimits(model.spendLimits);
            this.nextToken(model.nextToken);
        }

        public final List<SpendLimit.Builder> getSpendLimits() {
            List<SpendLimit.Builder> result = SpendLimitListCopier.copyToBuilder(this.spendLimits);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSpendLimits(Collection<SpendLimit.BuilderImpl> spendLimits) {
            this.spendLimits = SpendLimitListCopier.copyFromBuilder(spendLimits);
        }

        @Override
        public final Builder spendLimits(Collection<SpendLimit> spendLimits) {
            this.spendLimits = SpendLimitListCopier.copy(spendLimits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spendLimits(SpendLimit ... spendLimits) {
            this.spendLimits(Arrays.asList(spendLimits));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spendLimits(Consumer<SpendLimit.Builder> ... spendLimits) {
            this.spendLimits(Stream.of(spendLimits).map(c -> (SpendLimit)((SpendLimit.Builder)SpendLimit.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeSpendLimitsResponse build() {
            return new DescribeSpendLimitsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PinpointSmsVoiceV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeSpendLimitsResponse> {
        public Builder spendLimits(Collection<SpendLimit> var1);

        public Builder spendLimits(SpendLimit ... var1);

        public Builder spendLimits(Consumer<SpendLimit.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

