/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.privatenetworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.privatenetworks.model.ElevationReference;
import software.amazon.awssdk.services.privatenetworks.model.ElevationUnit;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Position
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Position> {
    private static final SdkField<Double> ELEVATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("elevation").getter(Position.getter(Position::elevation)).setter(Position.setter(Builder::elevation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("elevation").build()}).build();
    private static final SdkField<String> ELEVATION_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("elevationReference").getter(Position.getter(Position::elevationReferenceAsString)).setter(Position.setter(Builder::elevationReference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("elevationReference").build()}).build();
    private static final SdkField<String> ELEVATION_UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("elevationUnit").getter(Position.getter(Position::elevationUnitAsString)).setter(Position.setter(Builder::elevationUnit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("elevationUnit").build()}).build();
    private static final SdkField<Double> LATITUDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("latitude").getter(Position.getter(Position::latitude)).setter(Position.setter(Builder::latitude)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latitude").build()}).build();
    private static final SdkField<Double> LONGITUDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("longitude").getter(Position.getter(Position::longitude)).setter(Position.setter(Builder::longitude)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("longitude").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ELEVATION_FIELD, ELEVATION_REFERENCE_FIELD, ELEVATION_UNIT_FIELD, LATITUDE_FIELD, LONGITUDE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("elevation", ELEVATION_FIELD);
            this.put("elevationReference", ELEVATION_REFERENCE_FIELD);
            this.put("elevationUnit", ELEVATION_UNIT_FIELD);
            this.put("latitude", LATITUDE_FIELD);
            this.put("longitude", LONGITUDE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Double elevation;
    private final String elevationReference;
    private final String elevationUnit;
    private final Double latitude;
    private final Double longitude;

    private Position(BuilderImpl builder) {
        this.elevation = builder.elevation;
        this.elevationReference = builder.elevationReference;
        this.elevationUnit = builder.elevationUnit;
        this.latitude = builder.latitude;
        this.longitude = builder.longitude;
    }

    public final Double elevation() {
        return this.elevation;
    }

    public final ElevationReference elevationReference() {
        return ElevationReference.fromValue(this.elevationReference);
    }

    public final String elevationReferenceAsString() {
        return this.elevationReference;
    }

    public final ElevationUnit elevationUnit() {
        return ElevationUnit.fromValue(this.elevationUnit);
    }

    public final String elevationUnitAsString() {
        return this.elevationUnit;
    }

    public final Double latitude() {
        return this.latitude;
    }

    public final Double longitude() {
        return this.longitude;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.elevation());
        hashCode = 31 * hashCode + Objects.hashCode(this.elevationReferenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.elevationUnitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.latitude());
        hashCode = 31 * hashCode + Objects.hashCode(this.longitude());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Position)) {
            return false;
        }
        Position other = (Position)obj;
        return Objects.equals(this.elevation(), other.elevation()) && Objects.equals(this.elevationReferenceAsString(), other.elevationReferenceAsString()) && Objects.equals(this.elevationUnitAsString(), other.elevationUnitAsString()) && Objects.equals(this.latitude(), other.latitude()) && Objects.equals(this.longitude(), other.longitude());
    }

    public final String toString() {
        return ToString.builder((String)"Position").add("Elevation", (Object)this.elevation()).add("ElevationReference", (Object)this.elevationReferenceAsString()).add("ElevationUnit", (Object)this.elevationUnitAsString()).add("Latitude", (Object)this.latitude()).add("Longitude", (Object)this.longitude()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "elevation": {
                return Optional.ofNullable(clazz.cast(this.elevation()));
            }
            case "elevationReference": {
                return Optional.ofNullable(clazz.cast(this.elevationReferenceAsString()));
            }
            case "elevationUnit": {
                return Optional.ofNullable(clazz.cast(this.elevationUnitAsString()));
            }
            case "latitude": {
                return Optional.ofNullable(clazz.cast(this.latitude()));
            }
            case "longitude": {
                return Optional.ofNullable(clazz.cast(this.longitude()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Position, T> g) {
        return obj -> g.apply((Position)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double elevation;
        private String elevationReference;
        private String elevationUnit;
        private Double latitude;
        private Double longitude;

        private BuilderImpl() {
        }

        private BuilderImpl(Position model) {
            this.elevation(model.elevation);
            this.elevationReference(model.elevationReference);
            this.elevationUnit(model.elevationUnit);
            this.latitude(model.latitude);
            this.longitude(model.longitude);
        }

        public final Double getElevation() {
            return this.elevation;
        }

        public final void setElevation(Double elevation) {
            this.elevation = elevation;
        }

        @Override
        public final Builder elevation(Double elevation) {
            this.elevation = elevation;
            return this;
        }

        public final String getElevationReference() {
            return this.elevationReference;
        }

        public final void setElevationReference(String elevationReference) {
            this.elevationReference = elevationReference;
        }

        @Override
        public final Builder elevationReference(String elevationReference) {
            this.elevationReference = elevationReference;
            return this;
        }

        @Override
        public final Builder elevationReference(ElevationReference elevationReference) {
            this.elevationReference(elevationReference == null ? null : elevationReference.toString());
            return this;
        }

        public final String getElevationUnit() {
            return this.elevationUnit;
        }

        public final void setElevationUnit(String elevationUnit) {
            this.elevationUnit = elevationUnit;
        }

        @Override
        public final Builder elevationUnit(String elevationUnit) {
            this.elevationUnit = elevationUnit;
            return this;
        }

        @Override
        public final Builder elevationUnit(ElevationUnit elevationUnit) {
            this.elevationUnit(elevationUnit == null ? null : elevationUnit.toString());
            return this;
        }

        public final Double getLatitude() {
            return this.latitude;
        }

        public final void setLatitude(Double latitude) {
            this.latitude = latitude;
        }

        @Override
        public final Builder latitude(Double latitude) {
            this.latitude = latitude;
            return this;
        }

        public final Double getLongitude() {
            return this.longitude;
        }

        public final void setLongitude(Double longitude) {
            this.longitude = longitude;
        }

        @Override
        public final Builder longitude(Double longitude) {
            this.longitude = longitude;
            return this;
        }

        public Position build() {
            return new Position(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Position> {
        public Builder elevation(Double var1);

        public Builder elevationReference(String var1);

        public Builder elevationReference(ElevationReference var1);

        public Builder elevationUnit(String var1);

        public Builder elevationUnit(ElevationUnit var1);

        public Builder latitude(Double var1);

        public Builder longitude(Double var1);
    }
}

