/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The operation that uses this structure is retired. Amazon Redshift automatically determines whether to use AQUA
 * (Advanced Query Accelerator).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AquaConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AquaConfiguration.Builder, AquaConfiguration> {
    private static final SdkField<String> AQUA_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AquaStatus").getter(getter(AquaConfiguration::aquaStatusAsString)).setter(setter(Builder::aquaStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AquaStatus").build()).build();

    private static final SdkField<String> AQUA_CONFIGURATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AquaConfigurationStatus").getter(getter(AquaConfiguration::aquaConfigurationStatusAsString))
            .setter(setter(Builder::aquaConfigurationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AquaConfigurationStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AQUA_STATUS_FIELD,
            AQUA_CONFIGURATION_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String aquaStatus;

    private final String aquaConfigurationStatus;

    private AquaConfiguration(BuilderImpl builder) {
        this.aquaStatus = builder.aquaStatus;
        this.aquaConfigurationStatus = builder.aquaConfigurationStatus;
    }

    /**
     * <p>
     * This field is retired. Amazon Redshift automatically determines whether to use AQUA (Advanced Query Accelerator).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #aquaStatus} will
     * return {@link AquaStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #aquaStatusAsString}.
     * </p>
     * 
     * @return This field is retired. Amazon Redshift automatically determines whether to use AQUA (Advanced Query
     *         Accelerator).
     * @see AquaStatus
     */
    public final AquaStatus aquaStatus() {
        return AquaStatus.fromValue(aquaStatus);
    }

    /**
     * <p>
     * This field is retired. Amazon Redshift automatically determines whether to use AQUA (Advanced Query Accelerator).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #aquaStatus} will
     * return {@link AquaStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #aquaStatusAsString}.
     * </p>
     * 
     * @return This field is retired. Amazon Redshift automatically determines whether to use AQUA (Advanced Query
     *         Accelerator).
     * @see AquaStatus
     */
    public final String aquaStatusAsString() {
        return aquaStatus;
    }

    /**
     * <p>
     * This field is retired. Amazon Redshift automatically determines whether to use AQUA (Advanced Query Accelerator).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #aquaConfigurationStatus} will return {@link AquaConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #aquaConfigurationStatusAsString}.
     * </p>
     * 
     * @return This field is retired. Amazon Redshift automatically determines whether to use AQUA (Advanced Query
     *         Accelerator).
     * @see AquaConfigurationStatus
     */
    public final AquaConfigurationStatus aquaConfigurationStatus() {
        return AquaConfigurationStatus.fromValue(aquaConfigurationStatus);
    }

    /**
     * <p>
     * This field is retired. Amazon Redshift automatically determines whether to use AQUA (Advanced Query Accelerator).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #aquaConfigurationStatus} will return {@link AquaConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #aquaConfigurationStatusAsString}.
     * </p>
     * 
     * @return This field is retired. Amazon Redshift automatically determines whether to use AQUA (Advanced Query
     *         Accelerator).
     * @see AquaConfigurationStatus
     */
    public final String aquaConfigurationStatusAsString() {
        return aquaConfigurationStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(aquaStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(aquaConfigurationStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AquaConfiguration)) {
            return false;
        }
        AquaConfiguration other = (AquaConfiguration) obj;
        return Objects.equals(aquaStatusAsString(), other.aquaStatusAsString())
                && Objects.equals(aquaConfigurationStatusAsString(), other.aquaConfigurationStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AquaConfiguration").add("AquaStatus", aquaStatusAsString())
                .add("AquaConfigurationStatus", aquaConfigurationStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AquaStatus":
            return Optional.ofNullable(clazz.cast(aquaStatusAsString()));
        case "AquaConfigurationStatus":
            return Optional.ofNullable(clazz.cast(aquaConfigurationStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AquaStatus", AQUA_STATUS_FIELD);
        map.put("AquaConfigurationStatus", AQUA_CONFIGURATION_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AquaConfiguration, T> g) {
        return obj -> g.apply((AquaConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AquaConfiguration> {
        /**
         * <p>
         * This field is retired. Amazon Redshift automatically determines whether to use AQUA (Advanced Query
         * Accelerator).
         * </p>
         * 
         * @param aquaStatus
         *        This field is retired. Amazon Redshift automatically determines whether to use AQUA (Advanced Query
         *        Accelerator).
         * @see AquaStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AquaStatus
         */
        Builder aquaStatus(String aquaStatus);

        /**
         * <p>
         * This field is retired. Amazon Redshift automatically determines whether to use AQUA (Advanced Query
         * Accelerator).
         * </p>
         * 
         * @param aquaStatus
         *        This field is retired. Amazon Redshift automatically determines whether to use AQUA (Advanced Query
         *        Accelerator).
         * @see AquaStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AquaStatus
         */
        Builder aquaStatus(AquaStatus aquaStatus);

        /**
         * <p>
         * This field is retired. Amazon Redshift automatically determines whether to use AQUA (Advanced Query
         * Accelerator).
         * </p>
         * 
         * @param aquaConfigurationStatus
         *        This field is retired. Amazon Redshift automatically determines whether to use AQUA (Advanced Query
         *        Accelerator).
         * @see AquaConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AquaConfigurationStatus
         */
        Builder aquaConfigurationStatus(String aquaConfigurationStatus);

        /**
         * <p>
         * This field is retired. Amazon Redshift automatically determines whether to use AQUA (Advanced Query
         * Accelerator).
         * </p>
         * 
         * @param aquaConfigurationStatus
         *        This field is retired. Amazon Redshift automatically determines whether to use AQUA (Advanced Query
         *        Accelerator).
         * @see AquaConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AquaConfigurationStatus
         */
        Builder aquaConfigurationStatus(AquaConfigurationStatus aquaConfigurationStatus);
    }

    static final class BuilderImpl implements Builder {
        private String aquaStatus;

        private String aquaConfigurationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(AquaConfiguration model) {
            aquaStatus(model.aquaStatus);
            aquaConfigurationStatus(model.aquaConfigurationStatus);
        }

        public final String getAquaStatus() {
            return aquaStatus;
        }

        public final void setAquaStatus(String aquaStatus) {
            this.aquaStatus = aquaStatus;
        }

        @Override
        public final Builder aquaStatus(String aquaStatus) {
            this.aquaStatus = aquaStatus;
            return this;
        }

        @Override
        public final Builder aquaStatus(AquaStatus aquaStatus) {
            this.aquaStatus(aquaStatus == null ? null : aquaStatus.toString());
            return this;
        }

        public final String getAquaConfigurationStatus() {
            return aquaConfigurationStatus;
        }

        public final void setAquaConfigurationStatus(String aquaConfigurationStatus) {
            this.aquaConfigurationStatus = aquaConfigurationStatus;
        }

        @Override
        public final Builder aquaConfigurationStatus(String aquaConfigurationStatus) {
            this.aquaConfigurationStatus = aquaConfigurationStatus;
            return this;
        }

        @Override
        public final Builder aquaConfigurationStatus(AquaConfigurationStatus aquaConfigurationStatus) {
            this.aquaConfigurationStatus(aquaConfigurationStatus == null ? null : aquaConfigurationStatus.toString());
            return this;
        }

        @Override
        public AquaConfiguration build() {
            return new AquaConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
