/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The authorized token issuer for the Amazon Redshift IAM Identity Center application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuthorizedTokenIssuer implements SdkPojo, Serializable,
        ToCopyableBuilder<AuthorizedTokenIssuer.Builder, AuthorizedTokenIssuer> {
    private static final SdkField<String> TRUSTED_TOKEN_ISSUER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrustedTokenIssuerArn").getter(getter(AuthorizedTokenIssuer::trustedTokenIssuerArn))
            .setter(setter(Builder::trustedTokenIssuerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustedTokenIssuerArn").build())
            .build();

    private static final SdkField<List<String>> AUTHORIZED_AUDIENCES_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AuthorizedAudiencesList")
            .getter(getter(AuthorizedTokenIssuer::authorizedAudiencesList))
            .setter(setter(Builder::authorizedAudiencesList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizedAudiencesList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRUSTED_TOKEN_ISSUER_ARN_FIELD, AUTHORIZED_AUDIENCES_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String trustedTokenIssuerArn;

    private final List<String> authorizedAudiencesList;

    private AuthorizedTokenIssuer(BuilderImpl builder) {
        this.trustedTokenIssuerArn = builder.trustedTokenIssuerArn;
        this.authorizedAudiencesList = builder.authorizedAudiencesList;
    }

    /**
     * <p>
     * The ARN for the authorized token issuer for integrating Amazon Redshift with IDC Identity Center.
     * </p>
     * 
     * @return The ARN for the authorized token issuer for integrating Amazon Redshift with IDC Identity Center.
     */
    public final String trustedTokenIssuerArn() {
        return trustedTokenIssuerArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the AuthorizedAudiencesList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAuthorizedAudiencesList() {
        return authorizedAudiencesList != null && !(authorizedAudiencesList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of audiences for the authorized token issuer for integrating Amazon Redshift with IDC Identity Center.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAuthorizedAudiencesList} method.
     * </p>
     * 
     * @return The list of audiences for the authorized token issuer for integrating Amazon Redshift with IDC Identity
     *         Center.
     */
    public final List<String> authorizedAudiencesList() {
        return authorizedAudiencesList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(trustedTokenIssuerArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasAuthorizedAudiencesList() ? authorizedAudiencesList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthorizedTokenIssuer)) {
            return false;
        }
        AuthorizedTokenIssuer other = (AuthorizedTokenIssuer) obj;
        return Objects.equals(trustedTokenIssuerArn(), other.trustedTokenIssuerArn())
                && hasAuthorizedAudiencesList() == other.hasAuthorizedAudiencesList()
                && Objects.equals(authorizedAudiencesList(), other.authorizedAudiencesList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AuthorizedTokenIssuer").add("TrustedTokenIssuerArn", trustedTokenIssuerArn())
                .add("AuthorizedAudiencesList", hasAuthorizedAudiencesList() ? authorizedAudiencesList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrustedTokenIssuerArn":
            return Optional.ofNullable(clazz.cast(trustedTokenIssuerArn()));
        case "AuthorizedAudiencesList":
            return Optional.ofNullable(clazz.cast(authorizedAudiencesList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TrustedTokenIssuerArn", TRUSTED_TOKEN_ISSUER_ARN_FIELD);
        map.put("AuthorizedAudiencesList", AUTHORIZED_AUDIENCES_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuthorizedTokenIssuer, T> g) {
        return obj -> g.apply((AuthorizedTokenIssuer) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuthorizedTokenIssuer> {
        /**
         * <p>
         * The ARN for the authorized token issuer for integrating Amazon Redshift with IDC Identity Center.
         * </p>
         * 
         * @param trustedTokenIssuerArn
         *        The ARN for the authorized token issuer for integrating Amazon Redshift with IDC Identity Center.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustedTokenIssuerArn(String trustedTokenIssuerArn);

        /**
         * <p>
         * The list of audiences for the authorized token issuer for integrating Amazon Redshift with IDC Identity
         * Center.
         * </p>
         * 
         * @param authorizedAudiencesList
         *        The list of audiences for the authorized token issuer for integrating Amazon Redshift with IDC
         *        Identity Center.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizedAudiencesList(Collection<String> authorizedAudiencesList);

        /**
         * <p>
         * The list of audiences for the authorized token issuer for integrating Amazon Redshift with IDC Identity
         * Center.
         * </p>
         * 
         * @param authorizedAudiencesList
         *        The list of audiences for the authorized token issuer for integrating Amazon Redshift with IDC
         *        Identity Center.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizedAudiencesList(String... authorizedAudiencesList);
    }

    static final class BuilderImpl implements Builder {
        private String trustedTokenIssuerArn;

        private List<String> authorizedAudiencesList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AuthorizedTokenIssuer model) {
            trustedTokenIssuerArn(model.trustedTokenIssuerArn);
            authorizedAudiencesList(model.authorizedAudiencesList);
        }

        public final String getTrustedTokenIssuerArn() {
            return trustedTokenIssuerArn;
        }

        public final void setTrustedTokenIssuerArn(String trustedTokenIssuerArn) {
            this.trustedTokenIssuerArn = trustedTokenIssuerArn;
        }

        @Override
        public final Builder trustedTokenIssuerArn(String trustedTokenIssuerArn) {
            this.trustedTokenIssuerArn = trustedTokenIssuerArn;
            return this;
        }

        public final Collection<String> getAuthorizedAudiencesList() {
            if (authorizedAudiencesList instanceof SdkAutoConstructList) {
                return null;
            }
            return authorizedAudiencesList;
        }

        public final void setAuthorizedAudiencesList(Collection<String> authorizedAudiencesList) {
            this.authorizedAudiencesList = AuthorizedAudienceListCopier.copy(authorizedAudiencesList);
        }

        @Override
        public final Builder authorizedAudiencesList(Collection<String> authorizedAudiencesList) {
            this.authorizedAudiencesList = AuthorizedAudienceListCopier.copy(authorizedAudiencesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizedAudiencesList(String... authorizedAudiencesList) {
            authorizedAudiencesList(Arrays.asList(authorizedAudiencesList));
            return this;
        }

        @Override
        public AuthorizedTokenIssuer build() {
            return new AuthorizedTokenIssuer(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
