/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a parameter group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClusterParameterGroup implements SdkPojo, Serializable,
        ToCopyableBuilder<ClusterParameterGroup.Builder, ClusterParameterGroup> {
    private static final SdkField<String> PARAMETER_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParameterGroupName").getter(getter(ClusterParameterGroup::parameterGroupName))
            .setter(setter(Builder::parameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterGroupName").build())
            .build();

    private static final SdkField<String> PARAMETER_GROUP_FAMILY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParameterGroupFamily").getter(getter(ClusterParameterGroup::parameterGroupFamily))
            .setter(setter(Builder::parameterGroupFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterGroupFamily").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ClusterParameterGroup::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(ClusterParameterGroup::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETER_GROUP_NAME_FIELD,
            PARAMETER_GROUP_FAMILY_FIELD, DESCRIPTION_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String parameterGroupName;

    private final String parameterGroupFamily;

    private final String description;

    private final List<Tag> tags;

    private ClusterParameterGroup(BuilderImpl builder) {
        this.parameterGroupName = builder.parameterGroupName;
        this.parameterGroupFamily = builder.parameterGroupFamily;
        this.description = builder.description;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the cluster parameter group.
     * </p>
     * 
     * @return The name of the cluster parameter group.
     */
    public final String parameterGroupName() {
        return parameterGroupName;
    }

    /**
     * <p>
     * The name of the cluster parameter group family that this cluster parameter group is compatible with.
     * </p>
     * 
     * @return The name of the cluster parameter group family that this cluster parameter group is compatible with.
     */
    public final String parameterGroupFamily() {
        return parameterGroupFamily;
    }

    /**
     * <p>
     * The description of the parameter group.
     * </p>
     * 
     * @return The description of the parameter group.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of tags for the cluster parameter group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The list of tags for the cluster parameter group.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(parameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(parameterGroupFamily());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterParameterGroup)) {
            return false;
        }
        ClusterParameterGroup other = (ClusterParameterGroup) obj;
        return Objects.equals(parameterGroupName(), other.parameterGroupName())
                && Objects.equals(parameterGroupFamily(), other.parameterGroupFamily())
                && Objects.equals(description(), other.description()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClusterParameterGroup").add("ParameterGroupName", parameterGroupName())
                .add("ParameterGroupFamily", parameterGroupFamily()).add("Description", description())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ParameterGroupName":
            return Optional.ofNullable(clazz.cast(parameterGroupName()));
        case "ParameterGroupFamily":
            return Optional.ofNullable(clazz.cast(parameterGroupFamily()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ParameterGroupName", PARAMETER_GROUP_NAME_FIELD);
        map.put("ParameterGroupFamily", PARAMETER_GROUP_FAMILY_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClusterParameterGroup, T> g) {
        return obj -> g.apply((ClusterParameterGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClusterParameterGroup> {
        /**
         * <p>
         * The name of the cluster parameter group.
         * </p>
         * 
         * @param parameterGroupName
         *        The name of the cluster parameter group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterGroupName(String parameterGroupName);

        /**
         * <p>
         * The name of the cluster parameter group family that this cluster parameter group is compatible with.
         * </p>
         * 
         * @param parameterGroupFamily
         *        The name of the cluster parameter group family that this cluster parameter group is compatible with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterGroupFamily(String parameterGroupFamily);

        /**
         * <p>
         * The description of the parameter group.
         * </p>
         * 
         * @param description
         *        The description of the parameter group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The list of tags for the cluster parameter group.
         * </p>
         * 
         * @param tags
         *        The list of tags for the cluster parameter group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The list of tags for the cluster parameter group.
         * </p>
         * 
         * @param tags
         *        The list of tags for the cluster parameter group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The list of tags for the cluster parameter group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.redshift.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.redshift.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.redshift.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.redshift.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String parameterGroupName;

        private String parameterGroupFamily;

        private String description;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterParameterGroup model) {
            parameterGroupName(model.parameterGroupName);
            parameterGroupFamily(model.parameterGroupFamily);
            description(model.description);
            tags(model.tags);
        }

        public final String getParameterGroupName() {
            return parameterGroupName;
        }

        public final void setParameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
        }

        @Override
        public final Builder parameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
            return this;
        }

        public final String getParameterGroupFamily() {
            return parameterGroupFamily;
        }

        public final void setParameterGroupFamily(String parameterGroupFamily) {
            this.parameterGroupFamily = parameterGroupFamily;
        }

        @Override
        public final Builder parameterGroupFamily(String parameterGroupFamily) {
            this.parameterGroupFamily = parameterGroupFamily;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ClusterParameterGroup build() {
            return new ClusterParameterGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
